/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.integracao;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.integracao.ConfiguracaoException;
import com.csi.ctfclient.integracao.ConfiguracaoIntegrador;
import com.csi.ctfclient.integracao.Handler;
import com.csi.ctfclient.integracao.HandlerManager;
import com.csi.ctfclient.servicos.CTFClient;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import javax.swing.JOptionPane;

public class IntegradorMain {
    public IntegradorMain() {
        ILogger logger = CTFClientLogger.getIntegrador();
        try {
            logger.info("Abrindo servidor CTFClient...");
            try {
                logger.info("inicializando instancia do CTFClient...");
                CTFClient.getInstancia();
                logger.info("instancia do CTFClient inicializada.");
                ConfiguracaoIntegrador configuracao = ConfiguracaoIntegrador.newInstanceBuild();
                Handler handler = configuracao.getHandlerStream();
                handler.addHandlerListener(new HandlerManager(configuracao));
                handler.start();
            }
            catch (ExcecaoApiAc e) {
                logger.error("Erro ao inicializar CTFClient.");
            }
        }
        catch (ConfiguracaoException e) {
            logger.error("Erro no arquivo de configuracao do Integrador");
            JOptionPane.showMessageDialog(null, "Erro no arquivo de configuracao do Integrador");
        }
    }

    public static void main(String[] args) {
        if (args != null && args.length > 0) {
            if (args[0].equalsIgnoreCase("-versao") || args[0].equalsIgnoreCase("/versao")) {
                IntegradorMain.exibeVersao();
            } else {
                IntegradorMain.exibeHelp();
            }
        } else {
            try {
                new IntegradorMain();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void exibeVersao() {
        IntegradorMain.exibeHeader();
        System.out.println("CTFClient versao      -> C030201");
        System.out.println("Certificacao Cielo    -> C0212");
        System.out.println("Certificacao Redecard -> C0138");
        System.out.println("");
    }

    private static void exibeHelp() {
        IntegradorMain.exibeHeader();
        System.out.println("Uso: java -jar CTFClient.jar <opcao>");
        System.out.println("  Onde <opcao> pode ser:");
        System.out.println("  -versao        Exibe a versao do CTFClient");
        System.out.println("");
    }

    private static void exibeHeader() {
        System.out.println("");
        System.out.println("Auttar - Processamento de Dados LTDA");
        System.out.println("");
    }
}

