/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.integracao;

import com.csi.ctfclient.excecoes.ExcecaoParametroInvalido;
import com.csi.ctfclient.integracao.SocketHandler;
import com.csi.ctfclient.tools.communication.access.Conector;
import com.csi.ctfclient.tools.communication.access.ExcecaoConexaoNaoEstabelecida;
import java.io.InputStream;
import java.io.OutputStream;

public class SocketGetData
extends Thread {
    private Conector conexao;
    private Object source;
    private InputStream inputStream;
    private OutputStream outputStream;

    private SocketGetData(Object source, Conector conexao) {
        this.source = source;
        this.conexao = conexao;
    }

    public static SocketGetData getInstance(Object source, Conector conexao) {
        return new SocketGetData(source, conexao);
    }

    @Override
    public void run() {
        try {
            this.inputStream = this.conexao.getFluxoEntrada();
            this.outputStream = this.conexao.getFluxoSaida();
        }
        catch (ExcecaoConexaoNaoEstabelecida e) {
            e.printStackTrace();
            return;
        }
        ((SocketHandler)this.source).fireReadInputStream(this.inputStream, this.outputStream);
        try {
            this.conexao.fechaConexao();
        }
        catch (ExcecaoConexaoNaoEstabelecida e) {
            e.printStackTrace();
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setTimeout(int timeout) {
        try {
            this.conexao.setTimeout(timeout);
        }
        catch (ExcecaoParametroInvalido excecaoParametroInvalido) {
            // empty catch block
        }
    }
}

