/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.model.Cupom;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class ControladorCupons {
    private ILogger logger = CTFClientLogger.getCTFClient();
    private int versaoPathTerminal;
    private static ControladorCupons instancia;
    private final String CAMINHO_CUPONS;
    public static final String CUPOM_CLIENTE = "CUPOMCTF.1";
    public static final String CUPOM_LOJISTA = "CUPOMCTF.2";
    public static final String CUPOM_CLIENTE_REIMP = "CUPOMCTF.3";
    public static final String CUPOM_LOJISTA_REIMP = "CUPOMCTF.4";
    public static final String CUPOM_CLIENTE_REIMP_TEMP = "CUPOMCTF.5";
    public static final String CUPOM_LOJISTA_REIMP_TEMP = "CUPOMCTF.6";
    public static final String CUPOM_REDUZIDO = "REDUZIDO.1";

    private ControladorCupons() throws ExcecaoApiAc {
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        String caminhoCupons = "";
        caminhoCupons = caminhoCupons + conf.getEstabelecimento().substring(1);
        caminhoCupons = caminhoCupons + conf.getLoja() + ".";
        this.CAMINHO_CUPONS = caminhoCupons = caminhoCupons + conf.getTerminal();
    }

    public static ControladorCupons getInstance() throws ExcecaoApiAc {
        if (instancia == null) {
            instancia = new ControladorCupons();
        }
        return instancia;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cupom getCupom(String tipoCupom, int numeroTransacao) {
        ArrayList<String> colTmp = new ArrayList<String>();
        String linha = null;
        BufferedReader bufReader = null;
        try {
            if (numeroTransacao == 0) {
                ++numeroTransacao;
            }
            File cupom = new File(this.CAMINHO_CUPONS + File.separator + tipoCupom + StringUtil.completaString(String.valueOf(numeroTransacao), 2, '0', 3));
            FileReader fReader = new FileReader(cupom);
            bufReader = new BufferedReader(fReader);
            while ((linha = bufReader.readLine()) != null) {
                colTmp.add(linha);
            }
        }
        catch (Exception e) {
            this.logger.error("erro na leitura do cupom.", e);
        }
        finally {
            if (bufReader != null) {
                try {
                    bufReader.close();
                }
                catch (IOException e) {}
            }
        }
        if (colTmp.isEmpty()) {
            return null;
        }
        String[] buffer = new String[colTmp.size()];
        Iterator it = colTmp.iterator();
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = (String)it.next();
        }
        return new Cupom(buffer);
    }

    private String formatPathName(IdentTerminal identTerminal) {
        int idxEmpresa = this.versaoPathTerminal == 1 ? 0 : 1;
        String path = identTerminal.getEstabelecimento().substring(idxEmpresa) + identTerminal.getLoja() + "." + identTerminal.getTerminal() + File.separator;
        if (ControladorConfCTFClient.getDiretorioTrabalho() != null) {
            path = ControladorConfCTFClient.getDiretorioTrabalho() + path;
        }
        return path;
    }

    public boolean copiarCupom(IdentTerminal orig, IdentTerminal dest, String tipoCupom, int numeroTransacao) {
        File destCupom;
        String pathOrig = this.formatPathName(orig);
        String pathDest = this.formatPathName(dest);
        String numTrans = StringUtil.completaString(String.valueOf(numeroTransacao), 2, '0', 3);
        File origCupom = new File(pathOrig + File.separator + tipoCupom + numTrans);
        if (!origCupom.exists()) {
            this.logger.debug("cupom " + tipoCupom + numTrans + " nao existe para o terminal " + orig);
            return false;
        }
        File diretorioTerminalDest = new File(pathDest);
        if (!diretorioTerminalDest.exists()) {
            diretorioTerminalDest.mkdirs();
        }
        if ((destCupom = new File(pathDest + File.separator + tipoCupom + numTrans)).exists()) {
            destCupom.delete();
        }
        return this.copiarCupom(origCupom, destCupom);
    }

    public void deleteCupons(IdentTerminal identTerminal) {
        String path = this.formatPathName(identTerminal);
        File diretorio = new File(path);
        File[] cupons = diretorio.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().indexOf("CUPOMCTF") != -1 || file.getName().indexOf("REDUZIDO") != -1;
            }
        });
        if (cupons != null && cupons.length > 0) {
            for (int i = 0; i < cupons.length; ++i) {
                File file = cupons[i];
                file.delete();
            }
        }
    }

    public void deleteCupom(IdentTerminal identTerminal, String tipoCupom, int numeroTransacao) {
        String path = this.formatPathName(identTerminal);
        String numTrans = StringUtil.completaString(String.valueOf(numeroTransacao), 2, '0', 3);
        File file = new File(path + File.separator + tipoCupom + numTrans);
        if (file.exists()) {
            file.delete();
        }
    }

    private boolean copiarCupom(File origemCupom, File destinoCupom) {
        try {
            int c;
            FileReader in = new FileReader(origemCupom);
            FileWriter out = new FileWriter(destinoCupom);
            char[] buffer = new char[1024];
            while ((c = in.read(buffer)) != -1) {
                out.write(buffer, 0, c);
            }
            in.close();
            out.close();
            return true;
        }
        catch (IOException e) {
            this.logger.error("nao foi possivel copiar o arquivo " + origemCupom.getName());
            return false;
        }
    }

    public String carregarCupom(IdentTerminal identTerminal, String tipoCupom, int numeroTransacao) {
        String path = this.formatPathName(identTerminal);
        String numTrans = StringUtil.completaString(String.valueOf(numeroTransacao), 2, '0', 3);
        File fileCupom = new File(path + File.separator + tipoCupom + numTrans);
        if (!fileCupom.exists()) {
            this.logger.debug("Leitura cupom, cupom " + tipoCupom + numTrans + " nao existe para o terminal " + identTerminal);
            return null;
        }
        try {
            FileReader in = new FileReader(fileCupom);
            BufferedReader reader = new BufferedReader(in);
            String linha = reader.readLine();
            StringBuffer buffer = new StringBuffer();
            while (linha != null) {
                buffer.append(linha);
                linha = reader.readLine();
                if (linha == null) continue;
                buffer.append("#");
            }
            reader.close();
            in.close();
            return buffer.toString();
        }
        catch (IOException e) {
            this.logger.error("Nao foi possivel ler o arquivo " + fileCupom.getName());
            return null;
        }
    }
}

