/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes;

import com.csi.ctfclient.operacoes.Action;
import com.csi.ctfclient.operacoes.ActionForward;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.ReflectHelp;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;

public class ProcessManager {
    private static ILogger logger = CTFClientLogger.getProcessManager();
    private Vector<ExecutableProcess> processListManager = new Vector();
    private static ProcessManager processManager;
    private static final String MSG_OPEUSERCANCEL = "OPERACAO        CANCELADA";
    private static final String MSG_USERCANCEL = "OPERACAO CANCELADA";

    private ProcessManager() {
        logger.info("Inicializando ProcessManager");
    }

    public static ProcessManager getInstance() {
        if (processManager == null) {
            processManager = new ProcessManager();
        }
        return processManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutableProcess findProcess(int idProcess) throws Exception {
        ExecutableProcess execProcess = null;
        Vector<ExecutableProcess> vector = this.processListManager;
        synchronized (vector) {
            Enumeration<ExecutableProcess> enumerations = this.processListManager.elements();
            while (enumerations.hasMoreElements()) {
                Process process;
                execProcess = enumerations.nextElement();
                if (execProcess.getProcessList() == null || execProcess.getProcessList().isEmpty()) continue;
                Enumeration<Process> enumProcess = execProcess.getProcessList().elements();
                while (enumProcess.hasMoreElements() && (process = enumProcess.nextElement()).getIdProcess() != idProcess) {
                }
            }
        }
        return execProcess;
    }

    private void registyProcess(ExecutableProcess process) {
        this.processListManager.add(process);
    }

    public void process(Process process) {
        ExecutableProcess execProcess = new ExecutableProcess();
        this.registyProcess(execProcess);
        execProcess.execute(process);
        this.processListManager.remove(execProcess);
    }

    public void subProcess(int idParent, Process subProcess) throws Exception {
        ExecutableProcess execProcess = this.findProcess(idParent);
        execProcess.subProcess(idParent, subProcess);
    }

    class ExecutableProcess {
        private Vector<Process> processList = new Vector();

        public int getIdProcess() {
            return this.hashCode();
        }

        public Vector<Process> getProcessList() {
            return this.processList;
        }

        public void setProcessList(Vector<Process> processList) {
            this.processList = processList;
        }

        private Process findProcess(int id) throws Exception {
            Process process = null;
            Enumeration<Process> enumerations = this.processList.elements();
            while (enumerations.hasMoreElements() && (process = enumerations.nextElement()).getIdProcess() != id) {
            }
            return process;
        }

        public Process subProcess(int idParent, Process subProcess) throws Exception {
            logger.info("Iniciando Sub Processo - [" + subProcess.getKey() + "] - " + subProcess.getDescription());
            Process parentProcess = this.findProcess(idParent);
            subProcess.setPerifericos(parentProcess.getPerifericos());
            subProcess.setApitef(parentProcess.getApitef());
            subProcess.setParent(parentProcess);
            try {
                this.execute(subProcess);
            }
            catch (Throwable e) {
                subProcess.setErro(e);
                if (subProcess.getParent() != null) {
                    subProcess.getParent().setErro(e);
                }
                throw new Exception(e);
            }
            return subProcess;
        }

        private void registyProcess(Process process) {
            this.processList.add(process);
        }

        public void execute(Process process) {
            this.registyProcess(process);
            if (process.getStartKeyAction() != null && !process.getStartKeyAction().equals("")) {
                logger.info("Iniciando Processo - [" + process.getKey() + "] - " + process.getDescription());
                process.setState(2);
                this.executeAction(process.getAction(process.getStartKeyAction()), process);
                if (process.getEndKeyAction() != null) {
                    int state = process.getState();
                    this.executeAction(process.getAction(process.getEndKeyAction()), process);
                    process.setState(state);
                }
            }
            this.processList.remove(process);
        }

        private void executeAction(Action action, Process process) {
            block32: {
                try {
                    block6: while (action != null) {
                        String nameClass = action.getProcessClass().getName();
                        String simpleName = nameClass.substring(nameClass.lastIndexOf(".") + 1);
                        logger.info("action [" + action.getKey() + "] -> " + simpleName);
                        Class<?> classe = action.getProcessClass();
                        Object instancia = classe.newInstance();
                        Method method = ReflectHelp.getMethod(classe, "execute");
                        Object[] paramentro = new Object[]{process};
                        String resultForward = "";
                        while ((resultForward = (String)method.invoke(instancia, paramentro)).equals("RERUN")) {
                        }
                        ActionForward actionForward = action.getActionForward(resultForward);
                        logger.info("action [" + action.getKey() + "] -> " + resultForward);
                        if (actionForward != null) {
                            if (actionForward.getActionKey() == null || actionForward.getActionKey().equals("")) {
                                if (actionForward.getState() == 6) {
                                    action = null;
                                    process.setState(1);
                                } else if (actionForward.getState() == 3) {
                                    if (process.getState() == 3) break;
                                    if (process.isActiveDialogUserCancel()) {
                                        int opt = process.getPerifericos().exibeMenuCancelamento();
                                        switch (opt) {
                                            case 1: {
                                                if (Contexto.getContexto().getUserCancelMessage() != null && Contexto.getContexto().getUserCancelMessage().length() > 0) {
                                                    LayoutDisplay layoutDisplay = new LayoutDisplay(Contexto.getContexto().getUserCancelMessage(), 1500L);
                                                    process.getPerifericos().imprimeDisplay(layoutDisplay);
                                                    process.getPerifericos().limpaDisplay();
                                                }
                                                LayoutDisplay displayModel = new LayoutDisplay(ProcessManager.MSG_USERCANCEL, 1500L);
                                                boolean exibeUserCancelPinpad = true;
                                                if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().getCodigoOrigemTransacao() == 1) {
                                                    exibeUserCancelPinpad = false;
                                                }
                                                if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().getCodigoOrigemTransacao() == 4 && process.getPerifericos().getPin() != null && !process.getPerifericos().getPin().getHabilitado()) {
                                                    exibeUserCancelPinpad = false;
                                                }
                                                if (exibeUserCancelPinpad) {
                                                    if (process.getPerifericos().getPin() != null) {
                                                        process.getPerifericos().getPin().setMsgDisplay(ProcessManager.MSG_OPEUSERCANCEL);
                                                    }
                                                    process.getPerifericos().imprimeDisplay(displayModel);
                                                }
                                                process.setState(actionForward.getState());
                                                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5317, ProcessManager.MSG_USERCANCEL));
                                                process.setState(3);
                                                break;
                                            }
                                            case 2: {
                                                continue block6;
                                            }
                                        }
                                    } else {
                                        process.setState(3);
                                    }
                                } else if (actionForward.getState() == 1) {
                                    process.setState(actionForward.getState());
                                } else if (actionForward.getState() == 4) {
                                    process.setState(actionForward.getState());
                                } else if (actionForward.getState() == 5) {
                                    if (process.getState() == 5) break;
                                    process.getPerifericos().limpaDisplay();
                                    if (Contexto.getContexto().getUserCancelMessage() != null && Contexto.getContexto().getUserCancelMessage().length() > 0) {
                                        LayoutDisplay layoutDisplay = new LayoutDisplay(Contexto.getContexto().getUserCancelMessage(), 1500L);
                                        process.getPerifericos().imprimeDisplay(layoutDisplay);
                                        process.getPerifericos().limpaDisplay();
                                    }
                                    LayoutDisplay displayModel = new LayoutDisplay(ProcessManager.MSG_USERCANCEL, 1500L);
                                    boolean exibeUserCancelPinpad = true;
                                    if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().getCodigoOrigemTransacao() == 1) {
                                        exibeUserCancelPinpad = false;
                                    }
                                    if (exibeUserCancelPinpad) {
                                        if (process.getPerifericos().getPin() != null) {
                                            process.getPerifericos().getPin().setMsgDisplay(ProcessManager.MSG_OPEUSERCANCEL);
                                        }
                                        process.getPerifericos().imprimeDisplay(displayModel);
                                    }
                                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5317, ProcessManager.MSG_USERCANCEL));
                                    process.setState(5);
                                } else {
                                    actionForward.setState(0);
                                }
                                action = null;
                                continue;
                            }
                            if (!process.getActions().containsKey(actionForward.getActionKey())) {
                                throw new IllegalStateException("action [\"" + actionForward.getActionKey() + "\"] n\u00e3o encontrado");
                            }
                            action = process.getAction(actionForward.getActionKey());
                            continue;
                        }
                        action = null;
                        process.setState(1);
                    }
                }
                catch (Throwable throwable) {
                    logger.fatal("action [\"" + action.getKey() + "\"] erro -" + throwable.getClass().getName(), throwable);
                    process.setErro(throwable);
                    process.setState(1);
                    if (process.getParent() == null) break block32;
                    process.getParent().setErro(throwable);
                }
            }
        }
    }
}

