/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.contexto;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.action.ProcessConsultaCheque;
import com.csi.ctfclient.operacoes.action.ProcessCorrespondenteBancario;
import com.csi.ctfclient.operacoes.action.ProcessPagamentoContas;
import com.csi.ctfclient.operacoes.action.ProcessPagamentoFaturaCartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import java.math.BigDecimal;

public class TrataLegadoUtil {
    public static BigDecimal calculaValorTransacao(Process dados) {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (dados instanceof ProcessCorrespondenteBancario) {
            BigDecimal valorTransacao = new BigDecimal(0);
            if (saidaApiTefC != null && saidaApiTefC.isPermiteAlteracaoValorPagamentoCorban()) {
                return entradaApiTefC.getValorTransacao();
            }
            valorTransacao = saidaApiTefC != null && saidaApiTefC.getValorTransacao() != null && saidaApiTefC.getValorTransacao().doubleValue() > 0.0 ? saidaApiTefC.getValorTransacao() : entradaApiTefC.getValorDocumento();
            if (saidaApiTefC != null && (!saidaApiTefC.isCapturaAcrescimo() && !saidaApiTefC.isCapturaDesconto() || saidaApiTefC.isValorTotalJaCalculado())) {
                return valorTransacao;
            }
            if (entradaApiTefC.getValorDesconto() != null) {
                valorTransacao = valorTransacao.subtract(entradaApiTefC.getValorDesconto());
            }
            if (entradaApiTefC.getValorAcrescimo() != null) {
                valorTransacao = valorTransacao.add(entradaApiTefC.getValorAcrescimo());
            }
            return valorTransacao;
        }
        if (dados instanceof ProcessConsultaCheque) {
            return entradaApiTefC.getValorDocumento();
        }
        if (dados instanceof ProcessPagamentoFaturaCartao) {
            if (entradaApiTefC.getIdentificacaoPagamento() == 1) {
                return entradaApiTefC.getValorTransacao();
            }
            return entradaApiTefC.getValorDocumento();
        }
        return null;
    }

    public static void calculaValorTransacao(Process process, BigDecimal valorTransacao) {
        if (process instanceof ProcessPagamentoFaturaCartao) {
            EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
            entradaApiTefC.setValorTransacao(valorTransacao);
        } else if (process instanceof ProcessCorrespondenteBancario) {
            EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
            entradaApiTefC.setValorTransacao(TrataLegadoUtil.calculaValorTransacao(process));
        }
    }

    public static String getTipoOperacao(Process process) {
        if (process instanceof ProcessPagamentoContas) {
            int tipoPagamento = Contexto.getContexto().getTipoPagamento();
            int tipoConta = Contexto.getContexto().getTipoConta();
            if (tipoPagamento == 1) {
                if (tipoConta == 2) {
                    return "OPERACAO PAGAMENTO DE CONTAS DINHEIRO CONVENIO";
                }
                if (tipoConta == 1) {
                    return "OPERACAO PAGAMENTO DE CONTAS DINHEIRO TITULO";
                }
            } else if (tipoPagamento == 4) {
                return "OPERACAO PAGAMENTO DE CONTAS DEBITO";
            }
            throw new IllegalArgumentException("Transa\u00e7\u00e3o n\u00e3o encotrada");
        }
        return Contexto.getContexto().getTipoOperacao();
    }
}

