/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public abstract class MicAbstractEnvioConsulta {
    public static final String SUCESS = "SUCESS";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String ERROR = "ERROR";
    private ILogger logger = CTFClientLogger.getCTFClient();

    protected abstract String getCodigoTransacao(Process var1) throws IllegalStateException;

    protected abstract String getOperacao() throws IllegalStateException;

    public String execute(Process dados) throws ExcecaoApiAc {
        ConfCTFClient conf;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        if (entrada == null) {
            entrada = new EntradaApiTefC();
        }
        if (!(conf = ControladorConfCTFClient.getInstance().getConfig()).isIntegracaoWeb()) {
            ControladorPerifericos perifericos = dados.getPerifericos();
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("ENVIO1G_TITLE"));
            perifericos.imprimeDisplay(displayModel);
        }
        entrada.setDataCliente(dados.getStartProcess());
        entrada.setTimeoutCtf(15);
        entrada.setOperacao(this.getOperacao());
        entrada.setValorTransacao(Contexto.getContexto().getEntradaApiTefC().getValorTransacao());
        if (this.getCodigoTransacao(dados) != null) {
            entrada.setOperacaoConsultada(this.getCodigoTransacao(dados));
        }
        if (conf.isMultiEC()) {
            entrada.setMultiEC(conf.isMultiEC());
            entrada.setCodigoGrupoMultiEC(conf.getCodigoGrupoMultiEC());
        }
        SaidaApiTefC saidaApiTefC = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        Contexto.getContexto().setSaidaConsulta(saidaApiTefC);
        if (Contexto.getContexto().getSaidaConsulta().getRetorno() == 0) {
            this.logger.info(this.getOperacao() + " APROVADA");
            return SUCESS;
        }
        this.logger.info(this.getOperacao() + " N\u00c3O APROVADA RETORNO :" + saidaApiTefC.getRetorno() + " CODIGO DETALHE " + saidaApiTefC.getCodigoErro());
        Contexto.getContexto().setSaidaApiTefC(saidaApiTefC);
        return ERROR;
    }
}

