/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractSolicitacaoTEF;

public abstract class MicAbstractSolicitacaoCartaoTEF
extends MicAbstractSolicitacaoTEF {
    public static final String ERRO_REJEITADO_AUTORIZADORA = "ERRO_REJEITADO_AUTORIZADORA";
    public static final String ERRO_TRANS_JA_EFETUADA = "ERRO_TRANS_JA_EFETUADA";
    public static final String ERRO_NAO_AUT_CARTAO = "ERRO_NAO_AUT_CARTAO";
    public static final String CREDITO_REFERIDO = "CREDITO_REFERIDO";

    @Override
    protected void initEntradaApiTefC(EntradaApiTefC entradaApiTefC, Process dados) throws ExcecaoApiAc {
        super.initEntradaApiTefC(entradaApiTefC, dados);
    }

    @Override
    protected String testaRetorno(SaidaApiTefC saidaApiTefC, Process dados) {
        String retorno = super.testaRetorno(saidaApiTefC, dados);
        if (saidaApiTefC != null && saidaApiTefC.getRetorno() != 0) {
            if (saidaApiTefC.getCodigoRespostaAutorizadora().equals("0ER")) {
                return ERRO_TRANS_JA_EFETUADA;
            }
            if (saidaApiTefC.getCodigoRespostaAutorizadora().equals("0F5")) {
                return ERRO_NAO_AUT_CARTAO;
            }
            if (saidaApiTefC.getCodigoRespostaAutorizadora().equals("077") && saidaApiTefC.isConfirnacaoPositiva()) {
                return CREDITO_REFERIDO;
            }
        }
        return retorno;
    }
}

