/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MicAlterarDataVencimentoCorBan {
    public static final String SUCCESS = "SUCCESS";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String INVALID_DATE = "INVALID_DATE";
    private ILogger logger = CTFClientLogger.getCTFClient();
    private InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();

    public String execute(Process dados) throws ExcecaoNaoLocal {
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        if (saida == null || !saida.isPermiteAlteracaoDataVencimentoCorban()) {
            return UNECESSARY;
        }
        if (saida.isDesconsiderarDataVencimentoCodigoBarras()) {
            entrada.setDataVencimentoCorBan(null);
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        SimpleDateFormat df = new SimpleDateFormat("ddMMyy");
        df.setLenient(false);
        String valorDefaultString = null;
        if (entrada.getDataVencimentoCorBan() != null) {
            valorDefaultString = df.format(entrada.getDataVencimentoCorBan());
        }
        String dataDigitada = "";
        boolean tamanhoInvalido = true;
        while (tamanhoInvalido) {
            LayoutDisplay displayModel = new LayoutDisplay(this.inter.getMessage("CAPDATVEN_TITLE"));
            EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_DATA_VENCIMENTO_DOCUMENTO, 1, true, 10, true, valorDefaultString);
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                return USER_CANCEL;
            }
            int num = eventoTeclado.getNumCaracteresDigitados();
            dataDigitada = eventoTeclado.getStringLida().substring(0, num);
            if (dataDigitada.length() != 6) continue;
            tamanhoInvalido = false;
        }
        Date novaDataVencimento = null;
        try {
            novaDataVencimento = df.parse(dataDigitada);
        }
        catch (Exception e) {
            this.exibeMensagemErro(perifericos, this.inter.getMessage("CAPDATVEN_ERROR"));
            return INVALID_DATE;
        }
        if (novaDataVencimento.equals(entrada.getDataVencimentoCorBan())) {
            this.logger.log("INFO", "Data de vencimento n\u00e3o alterada");
        } else {
            this.logger.log("INFO", "Data de vencimento alterada de '" + entrada.getDataVencimentoCorBan() + "' para '" + novaDataVencimento + "'");
            entrada.setDataVencimentoCorBan(novaDataVencimento);
        }
        return SUCCESS;
    }

    private void exibeMensagemErro(ControladorPerifericos perifericos, String msg) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(msg);
        perifericos.confirmaDado(displayModel);
    }
}

