/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.autenticacao.AutenticacaoUtil;
import com.csi.ctfclient.autenticacao.DadosAutenticacao;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoParametroInvalido;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.model.controller.ControladorApitefC;
import com.csi.ctfclient.tools.communication.Host;
import com.csi.ctfclient.tools.communication.ServicoCTF;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.ByteUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileOutputStream;
import java.security.MessageDigest;
import java.util.LinkedHashSet;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

public class MicAutenticacao {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_INTERNAL = "USER_CANCEL_INTERNAL";
    public static final String ERROR_AC = "ERROR_AC";
    private String login = null;
    private String password = null;
    private String cnpj = null;
    private String codigoAtivacaoMultiEC = null;
    private String codigoLoja = null;
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dados) throws Exception {
        return this.capturaDadosAutenticacao(dados, false);
    }

    private void limpaDadosAutenticacao() {
        this.login = null;
        this.password = null;
        this.cnpj = null;
        this.codigoAtivacaoMultiEC = null;
        this.codigoLoja = null;
    }

    private String capturaDadosAutenticacao(Process dados, boolean capturaLoja) throws Exception {
        ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
        boolean isHomologacao = confCTFClient.isHomologacao();
        if (!confCTFClient.isSuporteHttps()) {
            return SUCCESS;
        }
        AutenticacaoUtil autenticacaoUtil = AutenticacaoUtil.getInstance();
        if (autenticacaoUtil.isTokenAutorizacao()) {
            return SUCCESS;
        }
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        boolean isMultiEC = false;
        if (confCTFClient.isMultiEC()) {
            isMultiEC = true;
        }
        while (this.login == null || this.password == null || !isMultiEC && this.cnpj == null || isMultiEC && this.codigoAtivacaoMultiEC == null || this.codigoLoja == null && capturaLoja) {
            EventoTeclado eventoTeclado = null;
            LayoutDisplay layoutDisplay = null;
            if (this.login == null) {
                layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_TITLE")));
                layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_LOGIN"), 0, 1));
                eventoTeclado = (EventoTeclado)perifericos.capturaDado(layoutDisplay, ConstantesApiAc.CAP_AUT_LOGIN, 0, true, 0, true);
                this.login = eventoTeclado.getStringLida().substring(0, eventoTeclado.getNumCaracteresDigitados());
            } else if (this.password == null) {
                layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_TITLE")));
                layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_PASSWORD"), 0, 1));
                eventoTeclado = (EventoTeclado)perifericos.capturaDado(layoutDisplay, ConstantesApiAc.CAP_AUT_PASSWORD, 0, true, true);
                this.password = eventoTeclado.getStringLida().substring(0, eventoTeclado.getNumCaracteresDigitados());
            } else if (this.cnpj == null || isMultiEC && this.codigoAtivacaoMultiEC == null) {
                if (isMultiEC) {
                    layoutDisplay = new LayoutDisplay();
                    layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_TITLE")));
                    layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_ATIVACAO_MULTIEC"), 0, 1));
                    eventoTeclado = (EventoTeclado)perifericos.capturaDado(layoutDisplay, ConstantesApiAc.CAP_AUT_ATIVACAO_MULTIEC, 0, true, 0, true);
                    this.codigoAtivacaoMultiEC = eventoTeclado.getStringLida().substring(0, eventoTeclado.getNumCaracteresDigitados());
                } else {
                    layoutDisplay = new LayoutDisplay();
                    layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_TITLE")));
                    layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_CNPJ"), 0, 1));
                    eventoTeclado = (EventoTeclado)perifericos.capturaDado(layoutDisplay, ConstantesApiAc.CAP_AUT_CNPJ, 0, true, 0, true);
                    this.cnpj = eventoTeclado.getStringLida().substring(0, eventoTeclado.getNumCaracteresDigitados());
                }
            } else if (this.codigoLoja == null && capturaLoja) {
                layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_TITLE")));
                layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_LOJA"), 0, 1));
                eventoTeclado = (EventoTeclado)perifericos.capturaDado(layoutDisplay, ConstantesApiAc.CAP_CODIGO_LOJA, 0, true, 0, true);
                this.codigoLoja = eventoTeclado.getStringLida().substring(0, eventoTeclado.getNumCaracteresDigitados());
            }
            if (!"VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) continue;
            return USER_CANCEL;
        }
        JsonObject parameters = new JsonObject();
        parameters.addProperty("login", this.login.toLowerCase());
        parameters.addProperty("senha", this.password.toLowerCase());
        if (isMultiEC) {
            parameters.addProperty("codigoAtivacao", this.codigoAtivacaoMultiEC);
            parameters.addProperty("codigoMultiEC", confCTFClient.getCodigoGrupoMultiEC() + "");
        } else {
            parameters.addProperty("cnpj", this.cnpj);
        }
        if (capturaLoja) {
            parameters.addProperty("codigoLoja", this.codigoLoja.toLowerCase());
        }
        if (this.isWin()) {
            parameters.addProperty("tipo", "5");
        } else {
            parameters.addProperty("tipo", "6");
        }
        parameters.addProperty("suporteHttps", "true");
        parameters.addProperty("tipoIdentificacao", "3");
        parameters.addProperty("identificacao", AutenticacaoUtil.getIdentificao());
        parameters.addProperty("fabricante", this.getOSName());
        parameters.addProperty("modelo", this.getOSVersion());
        LayoutDisplay displayModel = new LayoutDisplay("AGUARDE...");
        perifericos.imprimeDisplay(displayModel);
        return this.processaResposta(dados, this.cnpj, parameters, isHomologacao, isMultiEC);
    }

    private boolean isWin() {
        String osName = this.getOSName();
        return osName.indexOf("win") >= 0;
    }

    private String getOSName() {
        return System.getProperty("os.name").toLowerCase();
    }

    private String getOSVersion() {
        return System.getProperty("os.version") + " - " + System.getProperty("os.arch");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processaResposta(Process dados, String cnpj, JsonObject parameters, boolean homologacao, boolean multiEC) throws Exception {
        CloseableHttpClient client = null;
        try {
            String string;
            String url = "https://autenticador.auttar.com.br/resources/v2/registro";
            String urlMultiEC = "https://autenticador.auttar.com.br/resources/registro/multiec";
            if (homologacao) {
                this.logger.info("autenticacao em ambiente de homologacao");
                url = "https://homologacao.auttar.com.br/autenticador/resources/v2/registro";
                urlMultiEC = "https://homologacao.auttar.com.br/autenticador/resources/registro/multiec";
            }
            HttpPost httpPost = null;
            if (multiEC) {
                this.logger.info("autenticacao de terminal multiEC");
                httpPost = new HttpPost(urlMultiEC);
            } else {
                httpPost = new HttpPost(url);
            }
            Gson gson = new Gson();
            StringEntity params = new StringEntity(gson.toJson((JsonElement)parameters));
            httpPost.setEntity((HttpEntity)params);
            httpPost.addHeader("content-type", "application/json");
            if (url.contains("https")) {
                SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(SSLContexts.createDefault(), new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
                client = HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).build();
            } else {
                client = HttpClients.createDefault();
            }
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            try {
                System.out.println("----------------------------------------");
                System.out.println(response.getStatusLine());
                HttpEntity entity = response.getEntity();
                string = this.processaResposta(response.getStatusLine().getStatusCode(), dados, EntityUtils.toString((HttpEntity)entity), cnpj, multiEC);
            }
            catch (Throwable throwable) {
                response.close();
                throw throwable;
            }
            response.close();
            return string;
        }
        finally {
            client.close();
        }
    }

    public String processaResposta(int httpCode, Process dados, String resposta, String cnpj, boolean multiEC) throws Exception {
        block35: {
            InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
            ControladorPerifericos perifericos = dados.getPerifericos();
            ControladorConfCTFClient controladorConfCTFClient = ControladorConfCTFClient.getInstance();
            ConfCTFClient newConfCTFClient = new ConfCTFClient();
            AutenticacaoUtil autenticacaoUtil = AutenticacaoUtil.getInstance();
            autenticacaoUtil.clean();
            JsonObject jsonObject = null;
            try {
                jsonObject = new JsonParser().parse(resposta).getAsJsonObject();
            }
            catch (JsonParseException e) {
                LayoutDisplay layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_TITLE")));
                layoutDisplay.addLinha(new Linha("ERRO NO PROCESSAMENTO", 0, 1));
                perifericos.confirmaDado(layoutDisplay);
                return "RERUN";
            }
            String certificado = null;
            String certificadoMD5 = null;
            String md5 = null;
            String token = null;
            String clientServicesHost = null;
            try {
                int retorno = 20;
                String mensagem = null;
                if (httpCode == 409 && jsonObject.has("code") && (retorno = jsonObject.get("code").getAsInt()) == 8) {
                    return this.capturaDadosAutenticacao(dados, true);
                }
                if (httpCode != 200) {
                    retorno = jsonObject.get("code").getAsInt();
                    if (jsonObject.has("message")) {
                        mensagem = jsonObject.get("message").getAsString();
                    }
                    this.limpaDadosAutenticacao();
                } else {
                    if (jsonObject.has("retorno")) {
                        retorno = jsonObject.get("retorno").getAsInt();
                    }
                    if (jsonObject.has("mensagem")) {
                        mensagem = jsonObject.get("mensagem").getAsString();
                    }
                }
                if (jsonObject.has("token")) {
                    token = jsonObject.get("token").getAsString();
                }
                if (retorno == 0) {
                    LayoutDisplay layoutDisplay;
                    newConfCTFClient.setCnpj(cnpj);
                    String terminal = null;
                    if (jsonObject.has("codigoterminal")) {
                        terminal = jsonObject.get("codigoterminal").getAsString();
                    } else if (jsonObject.has("codigoTerminal")) {
                        terminal = jsonObject.get("codigoTerminal").getAsString();
                    }
                    if (terminal != null) {
                        newConfCTFClient.setEstabelecimento(terminal.substring(0, 5));
                        newConfCTFClient.setLoja(terminal.substring(5, 9));
                        newConfCTFClient.setTerminal(terminal.substring(9));
                    }
                    JsonArray parametros = null;
                    parametros = jsonObject.get("parametros").isJsonArray() ? jsonObject.getAsJsonArray("parametros") : jsonObject.getAsJsonObject("parametros").getAsJsonArray("parametro");
                    if (parametros == null || parametros.size() <= 0) break block35;
                    for (int i = 0; i < parametros.size(); ++i) {
                        JsonObject parametro = parametros.get(i).getAsJsonObject();
                        if (parametro.get("id").getAsString().equalsIgnoreCase("hostctf")) {
                            String[] hostsArray = parametro.get("valor").getAsString().split(";");
                            if (hostsArray.length <= 0) continue;
                            LinkedHashSet<ServicoCTF> ips = new LinkedHashSet<ServicoCTF>();
                            for (int y = 0; y < hostsArray.length; ++y) {
                                ServicoCTF servico;
                                newConfCTFClient.setComunicacaoCTF(hostsArray);
                                String strHost = "";
                                if (!hostsArray[y].toLowerCase().contains("http")) continue;
                                strHost = hostsArray[y];
                                Host hostCTF = new Host(strHost);
                                try {
                                    servico = new ServicoCTF(hostCTF, "443", "HTTPS");
                                }
                                catch (ExcecaoParametroInvalido e) {
                                    this.logger.log(ERROR, "valor de parametro invalido ==> ips = protocolo, usar TCP, UDP ou UDP2, HTTPS");
                                    return ERROR;
                                }
                                ips.add(servico);
                            }
                            newConfCTFClient.setIps(ips);
                            continue;
                        }
                        if (parametro.get("id").getAsString().equalsIgnoreCase("ambiente")) {
                            parametro.get("valor").getAsString();
                            continue;
                        }
                        if (parametro.get("id").getAsString().equalsIgnoreCase("certificado-md5")) {
                            md5 = parametro.get("valor").getAsString();
                            continue;
                        }
                        if (parametro.get("id").getAsString().equalsIgnoreCase("certificado")) {
                            try {
                                certificado = parametro.get("valor").getAsString();
                                byte[] buffer = certificado.getBytes();
                                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                                messageDigest.reset();
                                messageDigest.update(buffer);
                                byte[] resultByte = messageDigest.digest();
                                certificadoMD5 = ByteUtil.byteArrayToHex(resultByte);
                                continue;
                            }
                            catch (Exception e) {
                                this.logger.error("erro: ", e);
                                LayoutDisplay layoutDisplay2 = new LayoutDisplay();
                                layoutDisplay2.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_TITLE")));
                                layoutDisplay2.addLinha(new Linha("CERTIFICADO INVALIDO", 0, 1));
                                perifericos.confirmaDado(layoutDisplay2);
                                return "RERUN";
                            }
                        }
                        if (!parametro.get("id").getAsString().equalsIgnoreCase("clienteservico-host")) continue;
                        clientServicesHost = parametro.get("valor").getAsString();
                    }
                    if (certificado != null && certificadoMD5 != null && certificadoMD5.equalsIgnoreCase(md5)) {
                        try {
                            String nomeCertificado = "ca-bundle.crt";
                            FileOutputStream fos = new FileOutputStream(new File(nomeCertificado));
                            fos.write(certificado.getBytes());
                            fos.flush();
                            fos.close();
                        }
                        catch (Exception e) {
                            this.logger.error("erro: ", e);
                            layoutDisplay = new LayoutDisplay();
                            layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_TITLE"), 0, 1));
                            layoutDisplay.addLinha(new Linha("ERRO AO GRAVAR CERTIFICADO."));
                            perifericos.confirmaDado(layoutDisplay);
                            return "RERUN";
                        }
                    }
                    if (controladorConfCTFClient.getConfig().isSuporteHttps()) {
                        DadosAutenticacao dadosAutenticacao = new DadosAutenticacao();
                        dadosAutenticacao.setToken(token);
                        dadosAutenticacao.setTerminal(terminal);
                        dadosAutenticacao.setClientServicesHost(clientServicesHost);
                        if (newConfCTFClient.getComunicacaoCTF() != null && newConfCTFClient.getComunicacaoCTF().length > 0) {
                            dadosAutenticacao.setCtfHosts(newConfCTFClient.getComunicacaoCTF());
                        }
                        dadosAutenticacao.setIdentificacao(AutenticacaoUtil.getIdentificao());
                        autenticacaoUtil.configDadosAutenticacao(dadosAutenticacao);
                        try {
                            controladorConfCTFClient.save(newConfCTFClient, true);
                        }
                        catch (ExcecaoApiAc e) {
                            autenticacaoUtil.clean();
                        }
                    }
                    try {
                        String root_path = System.getenv("CTFCLIENT_HOME") + File.separator;
                        FileOutputStream identification_file = new FileOutputStream(root_path + "ctfclient_info.ini");
                        String identification_line = "terminal_id=" + terminal;
                        identification_file.write(identification_line.getBytes());
                        identification_file.close();
                        FileOutputStream version_file = new FileOutputStream(root_path + "VERSION.G7T");
                        String version_line = "TEL_VERSION=\"C030201" + ControladorConfCTFClient.VERSAO_CLIENT_DRAFT + "\"";
                        version_file.write(version_line.getBytes());
                        version_file.close();
                    }
                    catch (Exception e) {
                        this.logger.error("erro ao escrever arquivos de versao: ", e);
                        layoutDisplay = new LayoutDisplay();
                        layoutDisplay.addLinha(new Linha("FALHA NO SETUP DE ATUALIZACAO", 0, 1));
                        perifericos.confirmaDado(layoutDisplay);
                        ControladorConfCTFClient.getInstance().resetDadosAutenticacao();
                        return ERROR;
                    }
                    LayoutDisplay layoutDisplay3 = new LayoutDisplay();
                    layoutDisplay3.addLinha(new Linha(mensagem.toUpperCase()));
                    perifericos.confirmaDado(layoutDisplay3);
                    dados.setApitef(ControladorApitefC.newInstancia());
                    return SUCCESS;
                }
                this.logger.error("erro: " + mensagem);
                LayoutDisplay layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_TITLE")));
                layoutDisplay.addLinha(new Linha(mensagem.toUpperCase(), 0, 1));
                perifericos.confirmaDado(layoutDisplay);
                return "RERUN";
            }
            catch (Exception e) {
                this.logger.error("erro", e);
            }
        }
        return ERROR;
    }
}

