/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emvfull.KeyFactory;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCaptura4UltimodigitoCartao {
    public static final String SUCESS = "SUCESS";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String ERRO_NOT_VALID = "ERRO_NOT_VALID";
    public static final String ERRO_NOT_VALID_AC = "ERRO_NOT_VALID_AC";

    public String execute(Process dado) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (Contexto.getContexto().getCartao() == null) {
            throw new IllegalArgumentException("Cartao n\u00e3o informado");
        }
        if (!Contexto.getContexto().getSaidaApiTefC().isPede4Digitos()) {
            return UNECESSARY;
        }
        if (Contexto.getContexto().isQuatroUltimosDigCapturados()) {
            return UNECESSARY;
        }
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (entradaIntegracao != null) {
            if (entradaIntegracao.isMultiTerminal()) {
                return SUCESS;
            }
            if (entradaIntegracao.isMultiTerminal()) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5303, inter.getMessage("CAP4ULTDIG_ERRO_NOT_VALID")));
                return ERRO_NOT_VALID_AC;
            }
        }
        ControladorPerifericos perifericos = dado.getPerifericos();
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage("CAP4ULTDIG_TITLE1")));
        displayModel.addLinha(new Linha(inter.getMessage("CAP4ULTDIG_TITLE2")));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_4ULTIMOS_DIGITOS, false, 12, true);
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            return USERCANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String digitos = eventoTeclado.getStringLida().substring(num);
        String pan = null;
        pan = KeyFactory.isChaveLocal() ? Contexto.getContexto().getEntradaApiTefC().getPAN() : Contexto.getContexto().getSaidaApiTefC().getPanMascarado();
        if (!this.isvalid4UltimoDigito(pan, digitos)) {
            this.exibeMensagem(perifericos, inter.getMessage("CAP4ULTDIG_ERRO_NOT_VALID"));
            Contexto.getContexto().setCartao(null);
            return ERRO_NOT_VALID;
        }
        if (entradaIntegracao != null && entradaIntegracao.isConsulta()) {
            Contexto.getContexto().setQuatroUltimosDigCapturados(true);
        }
        return SUCESS;
    }

    private boolean isvalid4UltimoDigito(String numero, String ultimos4digitos) {
        int tamanho = numero.length();
        return ultimos4digitos.equals(numero.substring(tamanho - 4, tamanho));
    }

    private void exibeMensagem(ControladorPerifericos perifericos, String messagem) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(messagem);
        perifericos.confirmaDado(displayModel);
    }
}

