/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.PerifericoEventHandler;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoLeitorDocumento;
import com.csi.ctfclient.tools.devices.EventoScanner;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.LeitorDocumento;
import com.csi.ctfclient.tools.devices.Scanner;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class MicCapturaCodigoBarrasCartaoPrepago {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String ERROR = "ERROR";
    public static final String ERROR_AC = "ERROR_AC";
    public static final String USER_CANCEL = "USER_CANCEL";
    private ILogger logger = CTFClientLogger.getPeriferico();

    public String execute(Process dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (Contexto.getContexto().getEntradaApiTefC().getCodigoBarrasCartaoPrepago() != null) {
            return FILLED;
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().isCodigoBarrasCtrl() && Contexto.getContexto().getEntradaIntegracao().isModoEntradaCodigoBarrasCtrl() && Contexto.getContexto().getEntradaIntegracao().getCodigoBarras().length() >= 32) {
            int modoEntrada = Contexto.getContexto().getEntradaIntegracao().getModoEntradaCodigoBarras();
            if (modoEntrada != 3 && modoEntrada != 3) {
                if (modoEntrada == 1) {
                    this.logger.log(ERROR, "Captura do c\u00f3digo de barras pelo teclado n\u00e3o permitido.");
                }
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5360, "MODO DE ENTRADA INVALIDO"));
                return ERROR_AC;
            }
            Contexto.getContexto().getEntradaApiTefC().setCodigoBarrasCartaoPrepago(Contexto.getContexto().getEntradaIntegracao().getCodigoBarras().substring(0, 32));
            return SUCCESS;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        Scanner scanner = null;
        try {
            scanner = perifericos.getScanner();
            if (scanner != null) {
                scanner.habilita();
            }
        }
        catch (ExcecaoPerifericos e) {
            this.logger.info("Scanner n\u00e3o conectado");
        }
        LeitorDocumento leitorDocumento = perifericos.getLeitorDocumento();
        try {
            if (leitorDocumento != null) {
                leitorDocumento.habilita();
            }
        }
        catch (ExcecaoPerifericos e) {
            this.logger.info("Leitor de documentos n\u00e3o conectado");
        }
        LayoutDisplay displayTitulo = null;
        ConstantesApiAc.TipoCampo mascaraEdicao = null;
        displayTitulo = new LayoutDisplay(inter.getMessage("CAPCODBARCATPRE_TITLE"));
        mascaraEdicao = ConstantesApiAc.CAP_CODIGO_BARRAS_CARTAO_PREPAGO_BLACKHAWK;
        PerifericoEventHandler.setActive(true);
        EventoDispositivoEntrada evento = perifericos.capturaDado(displayTitulo, mascaraEdicao, true, "", new long[]{1L, 2L, 16L});
        if (evento instanceof EventoTeclado) {
            EventoTeclado eventoTeclado = (EventoTeclado)evento;
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                try {
                    if (scanner != null) {
                        scanner.desabilita();
                    }
                }
                catch (ExcecaoPerifericos excecaoPerifericos) {
                    // empty catch block
                }
                return USER_CANCEL;
            }
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            String codigoBarras = eventoTeclado.getStringLida().substring(num);
            if (codigoBarras.length() != mascaraEdicao.getMascaraEdicao().length()) {
                this.logger.log("INFO", "Tamanho digitado \u00e9 menor que o requerido. Digitado: " + codigoBarras.length() + ", requerido: " + mascaraEdicao.getMascaraEdicao().length());
                LayoutDisplay displayError = new LayoutDisplay(inter.getMessage("CAPCODBARCATPRE_ERRO_TAMANHO_MINIMO"));
                perifericos.confirmaDado(displayError);
                return ERROR;
            }
            Contexto.getContexto().getEntradaApiTefC().setCodigoBarrasCartaoPrepago(codigoBarras);
        } else if (evento instanceof EventoScanner || evento instanceof EventoLeitorDocumento) {
            String codigoBarras = "";
            if (evento instanceof EventoScanner) {
                EventoScanner eventoScanner = (EventoScanner)evento;
                codigoBarras = eventoScanner.getRepresentacaoString();
            } else if (evento instanceof EventoLeitorDocumento) {
                EventoLeitorDocumento eventoLeitorDocumento = (EventoLeitorDocumento)evento;
                codigoBarras = eventoLeitorDocumento.getRepresentacaoString();
            }
            if (codigoBarras.length() != mascaraEdicao.getMascaraEdicao().length()) {
                LayoutDisplay displayError = new LayoutDisplay(inter.getMessage("CAPCODBARCATPRE_ERRO_TAMANHO_MINIMO"));
                perifericos.confirmaDado(displayError);
                return ERROR;
            }
            Contexto.getContexto().getEntradaApiTefC().setCodigoBarrasCartaoPrepago(codigoBarras);
        } else {
            throw new IllegalArgumentException("Tipo de evento n\u00e3o esperado");
        }
        try {
            if (scanner != null) {
                scanner.desabilita();
            }
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            // empty catch block
        }
        PerifericoEventHandler.setActive(false);
        return SUCCESS;
    }
}

