/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaDDD {
    public static final String SUCESS = "SUCESS";
    public static final String SUCESS_BLANK = "SUCESS_BLANK";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (entradaApiTefC.getDdd() != null) {
            return FILLED;
        }
        if (entradaIntegracao != null && entradaIntegracao.isDddCtrl()) {
            entradaApiTefC.setDdd(entradaIntegracao.getDdd());
            return SUCESS;
        }
        String valor = null;
        int caracteresDigitados = -1;
        ControladorPerifericos periferico = dados.getPerifericos();
        while (caracteresDigitados != 2 && caracteresDigitados != 3) {
            if (!this.isCapturaDddObrigatoria() && caracteresDigitados == 0) {
                return SUCESS_BLANK;
            }
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPDDD_TITLE"));
            EventoTeclado eventoTeclado = (EventoTeclado)periferico.capturaDado(displayModel, ConstantesApiAc.CAP_DDD_TELEFONE);
            if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                return USER_CANCEL;
            }
            caracteresDigitados = eventoTeclado.getNumCaracteresDigitados();
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            valor = eventoTeclado.getStringLida().substring(num).trim();
        }
        entradaApiTefC.setDdd(valor);
        return SUCESS;
    }

    private boolean isCapturaDddObrigatoria() {
        return !"OPERACAO CONSULTA CHEQUE".equals(Contexto.getContexto().getTipoOperacao()) && !"OPERACAO GARANTIA CHEQUE".equals(Contexto.getContexto().getTipoOperacao());
    }
}

