/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessLeituraPin;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.ControladorModeloPinPad;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.DadoSolicitaPin;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.generic.Ansi98Crypto;
import com.csi.ctfclient.tools.devices.generic.Des;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class MicCapturaDadosPinpad {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String CAPTURA_NAO_CONFIRMADA = "CAPTURA_NAO_CONFIRMADA";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String MSG_CONFIRMA_PINPAD = "CONFIRMA?";
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dados) throws Exception {
        PinEMV pinEMV = dados.getPerifericos().getPin();
        try {
            String capturaDado = this.capturaDadoPinpad(dados, pinEMV, 11, 11, "INFORME O CPF");
            String display = capturaDado.substring(0, 3) + "." + capturaDado.substring(3, 6) + "." + capturaDado.substring(6, 9) + "-" + capturaDado.substring(9);
            if (this.confirmaDado(dados, pinEMV, display)) {
                Contexto.getContexto().getSaidaApiTefC().setRetorno(0);
                Contexto.getContexto().setCapturaDadoPinpad(capturaDado);
                return SUCCESS;
            }
            Contexto.getContexto().getSaidaApiTefC().setRetorno(20);
            CodigoErroIntegracao erroIntegracao = new CodigoErroIntegracao(5380, "USUARIO NAO CONFIRMOU#O CPF");
            Contexto.getContexto().setErroIntegracao(erroIntegracao);
            dados.setActiveDialogUserCancel(false);
            return CAPTURA_NAO_CONFIRMADA;
        }
        catch (UserCancelException e) {
            Contexto.getContexto().getSaidaApiTefC().setRetorno(20);
            return USER_CANCEL;
        }
        catch (UserCancelInternalException e) {
            Contexto.getContexto().getSaidaApiTefC().setRetorno(20);
            return USER_CANCEL;
        }
        catch (ReadErrorException e) {
            Contexto.getContexto().getSaidaApiTefC().setRetorno(20);
            return ERROR;
        }
    }

    private String capturaDadoPinpad(Process dados, PinEMV pin, int tamMin, int tamMax, String display) throws ReadErrorException, UserCancelException, UserCancelInternalException {
        Criptografia criptografia = null;
        DadoSolicitaPin[] dadoSolicitaPins = null;
        boolean flagWKAuttar = true;
        try {
            criptografia = ControladorModeloPinPad.getInstance().getCriptografia(pin);
            if (flagWKAuttar) {
                int modoCriptografia = 0;
                int indiceMkAuttar = 0;
                String wkAuttar = "10BDA8B87A9E8357";
                criptografia = new Criptografia(modoCriptografia, indiceMkAuttar, wkAuttar, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dadoSolicitaPins = new DadoSolicitaPin[]{new DadoSolicitaPin(tamMin, tamMax, display)};
        ProcessManager processManager = ProcessManager.getInstance();
        ProcessLeituraPin processLeituraPin = new ProcessLeituraPin(criptografia, dadoSolicitaPins, false, false);
        processLeituraPin.setActiveDialogUserCancel(false);
        processLeituraPin.setTituloAguardaPin(display);
        try {
            processManager.subProcess(dados.getIdProcess(), processLeituraPin);
        }
        catch (Exception e) {
            throw new ReadErrorException();
        }
        if (processLeituraPin.getState() == 3) {
            throw new UserCancelException();
        }
        if (processLeituraPin.getState() == 5) {
            throw new UserCancelInternalException();
        }
        if (processLeituraPin.getState() == 1) {
            throw new ReadErrorException();
        }
        String capturaDado = this.decriptografaSenhaCTF(Contexto.getContexto().getPinInfo().getPinCriptografado(), criptografia);
        return capturaDado;
    }

    private String decriptografaSenhaCTF(String senhaCryptoPP, Criptografia criptografia) {
        String senhaDecriptografada = "";
        byte[] senhaPPBytes = Ansi98Crypto.chaveStrHex2Bin(senhaCryptoPP);
        byte[] chaveBytes = null;
        byte[] wkAuttarBytes = Ansi98Crypto.chaveStrHex2Bin(criptografia.getWorkingKey());
        chaveBytes = Ansi98Crypto.chaveStrHex2Bin("3132333435363738");
        senhaDecriptografada = Ansi98Crypto.chaveBin2StrHex(Des.decrypt(chaveBytes = Des.decrypt(chaveBytes, wkAuttarBytes), senhaPPBytes));
        if (senhaDecriptografada != null) {
            int tamanho = Integer.decode("0x" + senhaDecriptografada.substring(0, 2));
            senhaDecriptografada = senhaDecriptografada.substring(2, 2 + tamanho);
        }
        return senhaDecriptografada;
    }

    private boolean confirmaDado(Process dados, PinEMV pin, String dado) throws ExcecaoPerifericos {
        Criptografia criptografia = null;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        try {
            criptografia = ControladorModeloPinPad.getInstance().getCriptografia(pin);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String mensagemPin = StringUtil.completaString(dado, 16, ' ', 4) + MSG_CONFIRMA_PINPAD;
        ProcessManager processManager = ProcessManager.getInstance();
        ProcessLeituraPin processLeituraPin = new ProcessLeituraPin(criptografia, null, false, false);
        processLeituraPin.setActiveDialogUserCancel(false);
        processLeituraPin.setTituloAguardaPin(inter.getMessage("EXICONTEL_MSG_CONFIRMACAO"));
        dados.getPerifericos().getPin().setMsgDisplay(mensagemPin);
        processLeituraPin.setTipoLeituraPin(3);
        try {
            processManager.subProcess(dados.getIdProcess(), processLeituraPin);
            if (processLeituraPin.getState() == 3 || processLeituraPin.getState() == 5) {
                this.logger.info("confirmacao cancelada pelo usuario.");
                return false;
            }
            if (processLeituraPin.getState() == 1) {
                this.logger.error("erro na confirmacao do dado capturado.");
                return false;
            }
            if (processLeituraPin.getTeclaFuncaoPressionada() != 0) {
                this.logger.info("usuario nao confirmou o dado capturado.");
                return false;
            }
        }
        catch (Exception e) {
            this.logger.error("erro na confirmacao do dado capturado.", e);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        System.out.println(StringUtil.sprintf("%03.%03.%03-%02", new Object[]{"04604382476"}));
    }

    private class ReadErrorException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private ReadErrorException() {
        }
    }

    private class UserCancelInternalException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private UserCancelInternalException() {
        }
    }

    private class UserCancelException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private UserCancelException() {
        }
    }
}

