/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class MicCapturaDataAgendamento {
    public static final String FILLED = "FILLED";
    public static final String SUCESS = "SUCESS";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String EXCEDE_PRAZO = "EXCEDE_PRAZO";
    public static final String EXCEDE_PRAZO_AC = "EXCEDE_PRAZO_AC";
    public static final String INVALID_DATE = "INVALID_DATE";
    public static final String INVALID_DATE_AC = "INVALID_DATE_AC";
    private int prazoAgendamentoDia = -1;
    private int prazoMinimoAgendamentoDia = -1;

    public String execute(Process dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        ControladorPerifericos perifericos = dados.getPerifericos();
        if (entradaApiTefC.getDataVencimentoDebito() != null) {
            return FILLED;
        }
        this.prazoAgendamentoDia = saidaApiTefC.getMaximaDiaPre();
        this.prazoMinimoAgendamentoDia = saidaApiTefC.getMinDiasPre();
        if (entradaIntegracao != null && this.isValidaAgendamentoCancelamento(entradaIntegracao) && entradaIntegracao.isDataReferenciaCtrl()) {
            if (!this.isDataMinAgendamento(dados.getStartProcess(), entradaIntegracao.getDataReferencia())) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5313, inter.getMessage("CAPDATAGE_INVALID_DATE")));
                return INVALID_DATE_AC;
            }
            if (!this.isDataAgendamentoValida(dados.getStartProcess(), entradaIntegracao.getDataReferencia())) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5314, inter.getMessage("CAPDATAGE_EXCEDE_PRAZO")));
                return EXCEDE_PRAZO_AC;
            }
            this.setDataVencimento(entradaApiTefC, entradaIntegracao.getDataReferencia());
            return SUCESS;
        }
        int operacao = 0;
        if (entradaIntegracao != null) {
            operacao = entradaIntegracao.getOperacao();
        }
        String dataDigitada = "";
        boolean tamanhoInvalido = true;
        while (tamanhoInvalido) {
            String title = null;
            title = operacao == 128 || operacao == 411 ? inter.getMessage("CAPDATAGE_TITLE_CANCEL") : inter.getMessage("CAPDATAGE_TITLE");
            LayoutDisplay displayModel = new LayoutDisplay(title);
            EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_DATA_AGENDAMENTO, 0, true, 10, true);
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                return USERCANCEL;
            }
            int num = eventoTeclado.getNumCaracteresDigitados();
            dataDigitada = eventoTeclado.getStringLida().substring(0, num);
            if (dataDigitada.length() != 6) continue;
            tamanhoInvalido = false;
        }
        Date dataAgendamento = null;
        try {
            SimpleDateFormat df = new SimpleDateFormat("ddMMyy");
            df.setLenient(false);
            dataAgendamento = df.parse(dataDigitada);
            GregorianCalendar calender = new GregorianCalendar();
            int qtdDiasPre = saidaApiTefC.getMinDiasPre();
            if (qtdDiasPre == 0) {
                ++qtdDiasPre;
            }
            if (operacao == 128 && dataAgendamento.compareTo(entradaApiTefC.getDataTransacao()) != 1) {
                if (this.exibeMensagemDataInvalida(perifericos, inter.getMessage("CAPDATAGE_INVALID_DATE")).equals("ENTRA")) {
                    this.setDataVencimento(entradaApiTefC, null);
                    return INVALID_DATE;
                }
                return USERCANCEL;
            }
            calender.setTime(df.parse(df.format(new Date())));
            ((Calendar)calender).add(5, qtdDiasPre);
            if (calender.getTime().compareTo(dataAgendamento) == 1) {
                if (this.exibeMensagemDataInvalida(perifericos, inter.getMessage("CAPDATAGE_INVALID_DATE")).equals("ENTRA")) {
                    this.setDataVencimento(entradaApiTefC, null);
                    return INVALID_DATE;
                }
                return USERCANCEL;
            }
            if (!this.isDataAgendamentoValida(dados.getStartProcess(), dataAgendamento)) {
                if (this.exibeMensagemPrazoExcedido(perifericos, inter.getMessage("CAPDATAGE_EXCEDE_PRAZO")).equals("ENTRA")) {
                    this.setDataVencimento(entradaApiTefC, null);
                    return EXCEDE_PRAZO;
                }
                return USERCANCEL;
            }
        }
        catch (Exception e) {
            if (this.exibeMensagemDataInvalida(perifericos, inter.getMessage("CAPDATAGE_INVALID_DATE")).equals("ENTRA")) {
                this.setDataVencimento(entradaApiTefC, null);
                return INVALID_DATE;
            }
            return USERCANCEL;
        }
        this.setDataVencimento(entradaApiTefC, dataAgendamento);
        return SUCESS;
    }

    private void setDataVencimento(EntradaApiTefC entradaApiTefC, Date dataVencimento) {
        entradaApiTefC.setDataVencimentoDebito(dataVencimento);
        if (Contexto.getContexto().getCartao() != Cartao.DIGITADO || Contexto.getContexto().getPlano() == null || Contexto.getContexto().getPlano() != Plano.PREDATADO) {
            entradaApiTefC.setDataVencimento(dataVencimento);
        }
    }

    public boolean isDataMinAgendamento(Date nowDate, Date dataAgendamento) {
        try {
            SimpleDateFormat nowFormat = new SimpleDateFormat("ddMMyyyy");
            nowDate = nowFormat.parse(nowFormat.format(nowDate));
            dataAgendamento = nowFormat.parse(nowFormat.format(dataAgendamento));
            GregorianCalendar calenderAgendMin = new GregorianCalendar();
            calenderAgendMin.setTime(nowDate);
            calenderAgendMin.add(5, this.prazoMinimoAgendamentoDia);
            return !dataAgendamento.before(calenderAgendMin.getTime());
        }
        catch (ParseException e) {
            return false;
        }
    }

    public boolean isDataAgendamentoValida(Date nowDate, Date dataAgendamento) {
        try {
            SimpleDateFormat nowFormat = new SimpleDateFormat("ddMMyyyy");
            nowDate = nowFormat.parse(nowFormat.format(nowDate));
            dataAgendamento = nowFormat.parse(nowFormat.format(dataAgendamento));
            if (!this.isDataMinAgendamento(nowDate, dataAgendamento)) {
                return false;
            }
            GregorianCalendar calender = new GregorianCalendar();
            calender.setTime(nowDate);
            if (this.prazoAgendamentoDia >= 0) {
                calender.add(5, this.prazoAgendamentoDia);
                return !dataAgendamento.after(calender.getTime());
            }
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    private String exibeMensagemPrazoExcedido(ControladorPerifericos perifericos, String msgExcedePrazo) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(msgExcedePrazo);
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayModel);
        return eventoTeclado.getTeclaFinalizadora();
    }

    private String exibeMensagemDataInvalida(ControladorPerifericos perifericos, String msgInvalidDate) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(msgInvalidDate);
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayModel);
        return eventoTeclado.getTeclaFinalizadora();
    }

    private boolean isValidaAgendamentoCancelamento(EntradaCTFClientCtrl entradaIntegracao) {
        return entradaIntegracao.getOperacao() != 128 && entradaIntegracao.getOperacao() != 411;
    }
}

