/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MicCapturaDataTransacao {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USERCANCEL";
    public static final String INVALID_DATE = "INVALID_DATE";
    public static final String INVALID_DATE_AC = "INVALID_DATE_AC";
    public static final String UNECESSARY = "UNECESSARY";
    private InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();

    public String execute(Process dado) throws ExcecaoApiAc {
        if (Contexto.getContexto().getSaidaApiTefC() != null && !Contexto.getContexto().getSaidaApiTefC().isCapturaDataTransacao()) {
            return UNECESSARY;
        }
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        ControladorPerifericos perifericos = dado.getPerifericos();
        if (Contexto.getContexto().getEntradaApiTefC().getDataTransacao() != null) {
            if (!this.dataValida(Contexto.getContexto().getEntradaApiTefC().getDataTransacao(), dado.getStartProcess())) {
                if (conf.isIntegracaoWeb()) {
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5313, this.inter.getMessage("CAPDATTRA_ERROR")));
                    return INVALID_DATE_AC;
                }
                if (this.exibeMensagemDataInvalida(perifericos).equals("ENTRA")) {
                    return INVALID_DATE;
                }
                return USER_CANCEL;
            }
            return FILLED;
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null) {
            if (!Contexto.getContexto().getEntradaIntegracao().isDataReferenciaCtrl() && this.dataObrigatoria(Contexto.getContexto().getEntradaIntegracao().getOperacao())) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5313, this.inter.getMessage("CAPDATTRA_ERROR")));
                return INVALID_DATE_AC;
            }
            if (Contexto.getContexto().getEntradaIntegracao().isDataReferenciaCtrl()) {
                if (this.dataValida(Contexto.getContexto().getEntradaIntegracao().getDataReferencia(), dado.getStartProcess())) {
                    Contexto.getContexto().getEntradaApiTefC().setDataTransacao(Contexto.getContexto().getEntradaIntegracao().getDataReferencia());
                    return SUCESS;
                }
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5313, this.inter.getMessage("CAPDATTRA_ERROR")));
                return INVALID_DATE_AC;
            }
        }
        String dataDigitada = "";
        boolean tamanhoInvalido = true;
        while (tamanhoInvalido) {
            LayoutDisplay displayModel = new LayoutDisplay(this.inter.getMessage("CAPDATTRA_TITLE"));
            EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_DATA_TRANSACAO_ORIGINAL, 0, false, 19, true);
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                return USER_CANCEL;
            }
            int num = eventoTeclado.getNumCaracteresDigitados();
            dataDigitada = eventoTeclado.getStringLida().substring(0, num);
            if (dataDigitada.length() != 6) continue;
            tamanhoInvalido = false;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat("ddMMyy");
            df.setLenient(false);
            Contexto.getContexto().getEntradaApiTefC().setDataTransacao(df.parse(dataDigitada));
        }
        catch (Exception e) {
            if (this.exibeMensagemDataInvalida(perifericos).equals("ENTRA")) {
                return INVALID_DATE;
            }
            return USER_CANCEL;
        }
        if (!this.dataValida(Contexto.getContexto().getEntradaApiTefC().getDataTransacao(), dado.getStartProcess())) {
            Contexto.getContexto().getEntradaApiTefC().setDataTransacao(null);
            if (this.exibeMensagemDataInvalida(perifericos).equals("ENTRA")) {
                return INVALID_DATE;
            }
            return USER_CANCEL;
        }
        return SUCESS;
    }

    private String exibeMensagemDataInvalida(ControladorPerifericos perifericos) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(this.inter.getMessage("CAPDATTRA_ERROR"));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayModel);
        return eventoTeclado.getTeclaFinalizadora();
    }

    private boolean dataValida(Date dataTransacao, Date dataProcess) {
        return !dataTransacao.after(dataProcess);
    }

    private boolean dataObrigatoria(int operacao) {
        return false;
    }
}

