/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MicCapturaDataVencimentoCartaoPresente {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String INVALID_DATE = "INVALID_DATE";
    public static final String USER_CANCEL = "USER_CANCEL";

    public String execute(Process dados) throws ExcecaoNaoLocal, IllegalArgumentException {
        Date date;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (!Contexto.getContexto().getSaidaApiTefC().isSolicitarDataVencimentoCartao()) {
            return UNECESSARY;
        }
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        if (entrada.getDataVencimento() != null) {
            return FILLED;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        String digitos = null;
        int qtdDigitado = 0;
        while (qtdDigitado < 4) {
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("VENCAR_TITLE"));
            EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_DATA_VENCIMENTO_CARTAO, 0, false, 9, false);
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                return USER_CANCEL;
            }
            qtdDigitado = eventoTeclado.getNumCaracteresDigitados();
            int num = eventoTeclado.getNumCaracteresDigitados();
            digitos = eventoTeclado.getStringLida().substring(0, num);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMyy");
        dateFormat.setLenient(false);
        try {
            date = dateFormat.parse(digitos);
        }
        catch (ParseException e) {
            this.exibeMensagem(perifericos, inter.getMessage("VENCAR_NOT_VALID_DATE"));
            return INVALID_DATE;
        }
        entrada.setDataVencimento(date);
        return SUCCESS;
    }

    private void exibeMensagem(ControladorPerifericos perifericos, String messagem) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(messagem);
        perifericos.confirmaDado(displayModel);
    }
}

