/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class MicCapturaEmissaoCartao {
    public static final String SUCCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String ERRO_INVALID_DATA = "ERRO_INVALID_DATA";
    public static final String ERRO_INVALID_DATA_AC = "ERRO_INVALID_DATA_AC";

    public String execute(Process dadoCartao) throws ExcecaoNaoLocal, IllegalArgumentException {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (saidaApiTefC != null && !saidaApiTefC.isCapturaDataEmissao()) {
            return UNECESSARY;
        }
        if (entradaApiTefC.getDataEmissao() != null) {
            return FILLED;
        }
        if (entradaIntegracao != null) {
            if (entradaIntegracao.isDataEmissaoCtrl()) {
                String dataEmissaoAC = entradaIntegracao.getDataEmissao();
                if (dataEmissaoAC.length() != 8 || !this.isDataEmissaoValida(dataEmissaoAC.substring(2, 8))) {
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5383, inter.getMessage("VENCAR_NOT_VALID_DATE")));
                    return ERRO_INVALID_DATA_AC;
                }
                entradaApiTefC.setDataEmissao(this.formataDataEmissao(dataEmissaoAC.substring(2, 8)));
                return SUCCESS;
            }
            if (entradaIntegracao.isMultiTerminal()) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5383, inter.getMessage("VENCAR_NOT_VALID_DATE")));
                return ERRO_INVALID_DATA_AC;
            }
        }
        ControladorPerifericos perifericos = dadoCartao.getPerifericos();
        String digitos = null;
        int qtdDigitado = 0;
        while (qtdDigitado < 6) {
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("EMISSAOCAR_TITLE"));
            EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_DATA_EMISSAO_CARTAO, 0, false, 9, true);
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                return USERCANCEL;
            }
            qtdDigitado = eventoTeclado.getNumCaracteresDigitados();
            int num = eventoTeclado.getNumCaracteresDigitados();
            digitos = eventoTeclado.getStringLida().substring(0, num);
        }
        if (!this.isDataEmissaoValida(digitos)) {
            this.exibeMensagem(perifericos, inter.getMessage("VENCAR_NOT_VALID_DATE"));
            return ERRO_INVALID_DATA;
        }
        entradaApiTefC.setDataEmissao(this.formataDataEmissao(digitos));
        return SUCCESS;
    }

    private void exibeMensagem(ControladorPerifericos perifericos, String messagem) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(messagem);
        perifericos.confirmaDado(displayModel);
    }

    private boolean isDataEmissaoValida(String dataInformada) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMyyyy");
        dateFormat.setLenient(false);
        try {
            dateFormat.parse(dataInformada);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public Date formataDataEmissao(String value) {
        if (value.length() != 6) {
            throw new IllegalArgumentException("Data Invalida " + value);
        }
        try {
            int year = Integer.parseInt(value.substring(2));
            int month = Integer.parseInt(value.substring(0, 2));
            int day = 1;
            String dayString = StringUtil.completaString("" + day, 2, '0', 3);
            String dataString = StringUtil.completaString("" + month, 2, '0', 3);
            dataString = dataString + year;
            Date dateTemp = new SimpleDateFormat("ddMMyyyy").parse(dayString + dataString);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dateTemp);
            String lasDayMonthString = String.valueOf(calendar.getActualMaximum(5));
            Date date = new SimpleDateFormat("ddMMyyyy").parse(lasDayMonthString + dataString);
            return date;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Data Invalida " + value);
        }
    }
}

