/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaNomeCliente {
    public static final String SUCCESS = "SUCCESS";
    public static final String SUCCESS_BLANK = "SUCCESS_BLANK";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel;
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (entradaApiTefC.getNomeCliente() != null) {
            return FILLED;
        }
        if (entradaIntegracao != null) {
            if (entradaIntegracao.isNomeClienteCtrl()) {
                entradaApiTefC.setNomeCliente(entradaIntegracao.getNomeCliente().trim());
                return SUCCESS;
            }
            if (entradaIntegracao.isMultiTerminal()) {
                return SUCCESS_BLANK;
            }
        }
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        String valor = null;
        ControladorPerifericos periferico = dados.getPerifericos();
        EventoTeclado eventoTeclado = (EventoTeclado)periferico.capturaDado(displayModel = new LayoutDisplay(inter.getMessage("CAPNOMCLI_TITLE")), ConstantesApiAc.CAP_NOME_CLIENTE);
        if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
            return USER_CANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        valor = eventoTeclado.getStringLida().substring(num).trim();
        entradaApiTefC.setNomeCliente(valor);
        return SUCCESS;
    }
}

