/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaNumeroCiclos {
    public static final String SUCCESS = "SUCESS";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String FILLED = "FILLED";
    public static final String NUMERO_CICLOS_INVALIDO = "NUMERO_INVALIDO";
    public static final String NUMERO_CICLOS_INVALIDO_AC = "NUMERO_INVALIDO_AC";
    private static final String CAPTURA_PARCELADO_COM_E_SEM_JUROS = "8";

    public String execute(Process dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (Contexto.getContexto().getPlano() != Plano.PRIVATELABEL_APRAZO && Contexto.getContexto().getPlano() != Plano.PRIVATELABEL_AVISTA && saidaApiTefC != null && (saidaApiTefC.getCapturaNumeroCiclos() != null ? !this.isCapturaPlanoComESemJuros(saidaApiTefC.getCapturaNumeroCiclos()) : !saidaApiTefC.isCapturaCiclos())) {
            return SUCCESS;
        }
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        if (entradaApiTefC.getNumeroCiclos() >= 0 && !conf.isIntegracaoWeb()) {
            return FILLED;
        }
        if (entradaIntegracao != null && entradaIntegracao.isCiclosPularCtrl()) {
            entradaApiTefC.setNumeroCiclos(entradaIntegracao.getCiclosPular());
            return SUCCESS;
        }
        if (conf.isIntegracaoWeb()) {
            return SUCCESS;
        }
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPNUMCIC_TITLE"));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_NUMERO_CICLO, true, 14, true);
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            return USERCANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String digitos = eventoTeclado.getStringLida().substring(num);
        int numCiclos = 0;
        if (!"".equals(digitos.trim())) {
            numCiclos = Integer.parseInt(digitos);
        }
        entradaApiTefC.setNumeroCiclos(numCiclos);
        return SUCCESS;
    }

    private boolean isCapturaPlanoComESemJuros(String tipoCaptura) {
        if (CAPTURA_PARCELADO_COM_E_SEM_JUROS.equals(tipoCaptura)) {
            return Contexto.getContexto().getPlano() == Plano.ADMINISTRADORA || Contexto.getContexto().getPlano() == Plano.LOJISTA;
        }
        return false;
    }
}

