/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.math.BigDecimal;

public class MicCapturaNumeroParcela {
    private static ILogger logger = CTFClientLogger.getCTFClient();
    public static final String SUCESS = "SUCESS";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String FILLED = "FILLED";
    public static final String PARCELA_INVALIDA = "PARCELA_INVALIDA";
    public static final String PARCELA_INVALIDA_AC = "PARCELA_INVALIDA_AC";
    private int maxParcelas = 0;
    private int minParcelas = 0;
    private BigDecimal valorMinParcelaSemJuros = null;
    private BigDecimal valorMinParcelaComJuros = null;

    public String execute(Process dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        this.verificaPlano();
        logger.info("N\u00famero minimo de parcelas: " + this.getMinParcelas());
        logger.info("N\u00famero maximo de parcelas: " + this.getMaxParcelas());
        if (Contexto.getContexto().getEntradaIntegracao() != null) {
            if (Contexto.getContexto().getEntradaIntegracao().isNumeroParcelasCtrl()) {
                logger.info("Parcela informada AC: " + Contexto.getContexto().getEntradaIntegracao().getNumeroParcelas());
                if (Contexto.getContexto().getPlano() == Plano.LOJISTA) {
                    if (entradaApiTefC.getValorTransacao() != null && !this.isValorMinParcelaSemJuros(entradaApiTefC.getValorTransacao(), Contexto.getContexto().getEntradaIntegracao().getNumeroParcelas())) {
                        Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5308, inter.getMessage("CAPNUMPAR_VALOR_MIN_PARCELA")));
                        return PARCELA_INVALIDA_AC;
                    }
                } else if (Contexto.getContexto().getPlano() == Plano.ADMINISTRADORA && entradaApiTefC.getValorTransacao() != null && !this.isValorMinParcelaComJuros(entradaApiTefC.getValorTransacao(), Contexto.getContexto().getEntradaIntegracao().getNumeroParcelas())) {
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5308, inter.getMessage("CAPNUMPAR_VALOR_MIN_PARCELA")));
                    return PARCELA_INVALIDA_AC;
                }
                if (this.isVerificaRotativo(saidaApiTefC.isRotativoHabilitado(), Contexto.getContexto().getEntradaIntegracao().getNumeroParcelas()) && !this.isNumeroMinValido(Contexto.getContexto().getEntradaIntegracao().getNumeroParcelas())) {
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5309, inter.getMessage("CAPNUMPAR_NR_PARC_INVALIDO")));
                    return PARCELA_INVALIDA_AC;
                }
                if (!this.isNumeroMaxValido(Contexto.getContexto().getEntradaIntegracao().getNumeroParcelas())) {
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5310, inter.getMessage("CAPNUMPAR_EXCEDE_PARCELA")));
                    return PARCELA_INVALIDA_AC;
                }
                entradaApiTefC.setNumeroParcelas(Contexto.getContexto().getEntradaIntegracao().getNumeroParcelas());
                return SUCESS;
            }
            if (this.parcelaObrigatoria(Contexto.getContexto().getEntradaIntegracao().getOperacao())) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5309, inter.getMessage("CAPNUMPAR_NR_PARC_INVALIDO")));
                return PARCELA_INVALIDA_AC;
            }
        }
        if (entradaApiTefC.getNumeroParcelas() >= 0) {
            return FILLED;
        }
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPNUMPAR_TITLE"));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_NUMERO_PARCELAS, true, 14, true);
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            return USERCANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String numParcelas = eventoTeclado.getStringLida().substring(num);
        int parcelas = 0;
        try {
            parcelas = Integer.parseInt(numParcelas);
            logger.info("N\u00famero parcelas digitada: " + parcelas);
        }
        catch (NumberFormatException e) {
            if (this.exibeMensagem(inter.getMessage("CAPNUMPAR_NR_PARC_INVALIDO"), perifericos).equals("ENTRA")) {
                return PARCELA_INVALIDA;
            }
            return USERCANCEL;
        }
        if (this.isVerificaRotativo(saidaApiTefC.isRotativoHabilitado(), parcelas) && !this.isNumeroMinValido(parcelas)) {
            if (this.exibeMensagem(inter.getMessage("CAPNUMPAR_NR_PARC_INVALIDO"), perifericos).equals("ENTRA")) {
                logger.info("n\u00famero de parcelas invalido, " + inter.getMessage("CAPNUMPAR_NR_PARC_INVALIDO"));
                return PARCELA_INVALIDA;
            }
            return USERCANCEL;
        }
        if (!this.isNumeroMaxValido(parcelas)) {
            if (this.exibeMensagem(inter.getMessage("CAPNUMPAR_EXCEDE_PARCELA"), perifericos).equals("ENTRA")) {
                logger.info("excede parcelas, " + inter.getMessage("CAPNUMPAR_EXCEDE_PARCELA"));
                return PARCELA_INVALIDA;
            }
            return USERCANCEL;
        }
        if (Contexto.getContexto().getPlano() == Plano.LOJISTA) {
            if (entradaApiTefC.getValorTransacao() != null && !saidaApiTefC.isRotativoHabilitado() && !this.isValorMinParcelaSemJuros(entradaApiTefC.getValorTransacao(), parcelas)) {
                if (this.exibeMensagem(inter.getMessage("CAPNUMPAR_VALOR_MIN_PARCELA"), perifericos).equals("ENTRA")) {
                    return PARCELA_INVALIDA;
                }
                return USERCANCEL;
            }
        } else if (Contexto.getContexto().getPlano() == Plano.ADMINISTRADORA && entradaApiTefC.getValorTransacao() != null && !saidaApiTefC.isRotativoHabilitado() && !this.isValorMinParcelaComJuros(entradaApiTefC.getValorTransacao(), parcelas)) {
            if (this.exibeMensagem(inter.getMessage("CAPNUMPAR_VALOR_MIN_PARCELA"), perifericos).equals("ENTRA")) {
                return PARCELA_INVALIDA;
            }
            return USERCANCEL;
        }
        Contexto.getContexto().getEntradaApiTefC().setNumeroParcelas(parcelas);
        return SUCESS;
    }

    public int getMaxParcelas() {
        return this.maxParcelas;
    }

    public int getMinParcelas() {
        return this.minParcelas;
    }

    public BigDecimal getValorMinParcelaSemJuros() {
        return this.valorMinParcelaSemJuros;
    }

    public BigDecimal getValorMinParcelaComJuros() {
        return this.valorMinParcelaComJuros;
    }

    private boolean isVerificaRotativo(boolean rotativo, int parcelas) {
        return !rotativo || parcelas != 0 && parcelas != 1;
    }

    private void verificaPlano() throws IllegalStateException {
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        Plano plano = null;
        if (Contexto.getContexto().getPlano() == Plano.ADMINISTRADORA || Contexto.getContexto().getPlano() == Plano.ADMINISTRADORA_IATA) {
            this.maxParcelas = saidaApiTefC.getQtdMaximaParcelaComJuros();
            this.minParcelas = saidaApiTefC.getQtdMinimaParcelaComJuros();
            this.valorMinParcelaComJuros = saidaApiTefC.getValorMinimoParcelaComJuros();
            plano = Contexto.getContexto().getPlano();
        } else if (Contexto.getContexto().getPlano() == Plano.LOJISTA || Contexto.getContexto().getPlano() == Plano.LOJISTA_IATA) {
            this.maxParcelas = saidaApiTefC.getQtdMaximaParcelaSemJuros();
            this.minParcelas = saidaApiTefC.getQtdMinimaParcelaSemJuros();
            this.valorMinParcelaSemJuros = saidaApiTefC.getValorMinimoParcelaSemJuros();
            plano = Contexto.getContexto().getPlano();
        } else if (Contexto.getContexto().getPlano() == Plano.IATA) {
            this.maxParcelas = saidaApiTefC.getQtdMaximaParcelaSemJuros();
            this.minParcelas = saidaApiTefC.getQtdMinimaParcelaSemJuros();
            plano = Contexto.getContexto().getPlano();
        } else if (Contexto.getContexto().getPlano() == Plano.CDC || Contexto.getContexto().getPlano() == Plano.CREDIARIO) {
            this.maxParcelas = saidaApiTefC.getQtdMaximaParcelaComJuros();
            this.minParcelas = saidaApiTefC.getQtdMinimaParcelaComJuros();
            plano = Contexto.getContexto().getPlano();
        } else if (Contexto.getContexto().getPlano() == Plano.PARCELEMAIS) {
            this.maxParcelas = saidaApiTefC.getQtdMaximaParcelaSemJuros();
            this.minParcelas = saidaApiTefC.getQtdMinimaParcelaSemJuros();
            plano = Contexto.getContexto().getPlano();
        } else if (Contexto.getContexto().getPlano() == Plano.PARCELADO) {
            this.maxParcelas = saidaApiTefC.getQtdMaximaParcelaSemJuros();
            this.minParcelas = saidaApiTefC.getQtdMinimaParcelaSemJuros();
            plano = Contexto.getContexto().getPlano();
        } else if (Contexto.getContexto().getPlano() == Plano.PRIVATELABEL_APRAZO) {
            this.maxParcelas = saidaApiTefC.getQtdMaximaParcelaComJuros();
            this.minParcelas = saidaApiTefC.getQtdMinimaParcelaComJuros();
            plano = Contexto.getContexto().getPlano();
        }
        if (plano == null) {
            throw new IllegalStateException("Plano A prazo invalido");
        }
    }

    private String exibeMensagem(String msg, ControladorPerifericos perifericos) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(msg);
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayModel);
        return eventoTeclado.getTeclaFinalizadora();
    }

    private boolean parcelaObrigatoria(int operacao) {
        return false;
    }

    public boolean isNumeroMinValido(int numeroParcela) {
        return numeroParcela >= this.getMinParcelas() && numeroParcela > 1;
    }

    public boolean isNumeroMaxValido(int numeroParcela) {
        return numeroParcela <= this.getMaxParcelas();
    }

    public boolean isValorMinParcelaSemJuros(BigDecimal valorTransacao, int numeroParcela) {
        if (this.getValorMinParcelaSemJuros() == null) {
            return true;
        }
        BigDecimal valorParcela = valorTransacao.divide(new BigDecimal(numeroParcela), 6);
        return valorParcela.compareTo(this.getValorMinParcelaSemJuros()) != -1;
    }

    public boolean isValorMinParcelaComJuros(BigDecimal valorTransacao, int numeroParcela) {
        if (this.getValorMinParcelaComJuros() == null) {
            return true;
        }
        BigDecimal valorParcela = valorTransacao.divide(new BigDecimal(numeroParcela), 6);
        return valorParcela.compareTo(this.getValorMinParcelaComJuros()) != -1;
    }
}

