/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.model.Premio;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.text.DecimalFormat;

public class MicCapturaNumeroPremios {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String USER_CANCEL = "USER_CANCEL";
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (entradaApiTefC.getPremio() == null) {
            this.logger.log(ERROR, "Nenhum pr\u00eamio selecionado.");
            return ERROR;
        }
        Premio premio = entradaApiTefC.getPremio();
        if (premio.getQuantidade() == 1) {
            entradaApiTefC.setQuantidadePremios(1);
            return SUCCESS;
        }
        ControladorPerifericos periferico = dados.getPerifericos();
        periferico.limpaDisplay();
        String descricaoReduzidaPinpad = "";
        if (premio.getDescricao() != null && premio.getDescricao().length() > 0) {
            descricaoReduzidaPinpad = premio.getDescricao().length() > 16 ? premio.getDescricao().substring(0, 16) : premio.getDescricao();
        }
        DecimalFormat format = new DecimalFormat("#,##0");
        descricaoReduzidaPinpad = StringUtil.completaString(descricaoReduzidaPinpad, 16, ' ', 4);
        String textPinpad = descricaoReduzidaPinpad + inter.getMessage("CAPNUMPRE_QUANTIDADE") + " " + StringUtil.completaString(format.format(premio.getQuantidade()), 4, ' ', 3);
        if (periferico.getPin() != null) {
            periferico.getPin().setMsgDisplay(textPinpad);
        }
        int valor = 0;
        while (valor == 0 || valor > premio.getQuantidade()) {
            LayoutDisplay displayModel = new LayoutDisplay();
            if (premio.getDescricao() != null && premio.getDescricao().length() > 0) {
                displayModel.addLinha(new Linha(premio.getDescricao()));
            }
            String textDisplay = inter.getMessage("CAPNUMPRE_QUANTIDADE");
            String valorDefaul = StringUtil.completaString(format.format(premio.getQuantidade()), 2, '0', 3);
            displayModel.addLinha(new Linha(textDisplay + " " + valorDefaul, 0, 1));
            displayModel.addLinha(new Linha(inter.getMessage("CAPNUMPRE_RESGATAR")));
            EventoTeclado eventoTeclado = (EventoTeclado)periferico.capturaDado(displayModel, ConstantesApiAc.CAP_NUMERO_PREMIOS, false, 12, true);
            if (eventoTeclado.getTeclaFinalizadora().equals("ENTRA")) {
                int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
                String digitos = eventoTeclado.getStringLida().substring(num);
                if (digitos.equals("")) {
                    digitos = "00";
                }
                if ((valor = Integer.parseInt(digitos)) == 0) {
                    displayModel = new LayoutDisplay();
                    displayModel.addLinha(new Linha(inter.getMessage("CAPNUMPRE_VALOR_ZERO1")));
                    displayModel.addLinha(new Linha(inter.getMessage("CAPNUMPRE_VALOR_ZERO2")));
                    periferico.imprimeDisplay(displayModel);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    periferico.limpaDisplay();
                    continue;
                }
                if (valor <= premio.getQuantidade()) continue;
                displayModel = new LayoutDisplay();
                displayModel.addLinha(new Linha(inter.getMessage("CAPNUMPRE_VALOR_EXCEDE1")));
                displayModel.addLinha(new Linha(inter.getMessage("CAPNUMPRE_VALOR_EXCEDE2")));
                displayModel.addLinha(new Linha(inter.getMessage("CAPNUMPRE_VALOR_EXCEDE3")));
                displayModel.addLinha(new Linha(inter.getMessage("CAPNUMPRE_VALOR_EXCEDE4")));
                periferico.imprimeDisplay(displayModel);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                periferico.limpaDisplay();
                continue;
            }
            if (!eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) continue;
            entradaApiTefC.setPremio(null);
            return USER_CANCEL;
        }
        entradaApiTefC.setQuantidadePremios(valor);
        return SUCCESS;
    }
}

