/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.model.Produto;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaProdutoDinamico {
    public static final String PRODUTO_DEFAULT = "PRODUTO_DEFAULT";
    public static final String PRODUTO_SELECIONADO = "PRODUTO_SELECIONADO";
    public static final String CANCELADO_USUARIO = "CANCELADO_USUARIO";

    public String execute(Process dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        Produto[] produtos = Contexto.getContexto().getSaidaApiTefC().getProdutos();
        if (produtos != null && produtos.length != 0) {
            if (produtos.length > 1) {
                LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("EXIMENDIN_TITLE"), true);
                for (int i = 1; i <= produtos.length; ++i) {
                    Produto produto = produtos[i - 1];
                    layoutMenu.addItem(new ItemMenu(produto.getDescricao(), String.valueOf(i)));
                }
                int opcao = perifericos.imprimeMenu(layoutMenu);
                if (opcao == -1) {
                    return CANCELADO_USUARIO;
                }
                Contexto.getContexto().setSaidaApiTefC(null);
                Contexto.getContexto().getEntradaApiTefC().setCodigoProduto(produtos[opcao - 1].getCodigo());
                Contexto.getContexto().getEntradaApiTefC().setFluxoTef(produtos[opcao - 1].getKeyFluxo());
                Contexto.getContexto().getEntradaApiTefC().setCodigoBandeira(produtos[opcao - 1].getCodigoBandeira());
                return PRODUTO_SELECIONADO;
            }
            Contexto.getContexto().getEntradaApiTefC().setCodigoProduto(produtos[0].getCodigo());
            Contexto.getContexto().getEntradaApiTefC().setFluxoTef(produtos[0].getKeyFluxo());
            Contexto.getContexto().getEntradaApiTefC().setCodigoBandeira(produtos[0].getCodigoBandeira());
            return PRODUTO_DEFAULT;
        }
        return PRODUTO_DEFAULT;
    }
}

