/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaRg {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String USER_CANCEL = "USER_CANCEL";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (saidaApiTefC != null && !saidaApiTefC.isCapturaRg()) {
            return NOT_REQUIRED;
        }
        if (entradaApiTefC.getRg() != null) {
            return FILLED;
        }
        if (entradaIntegracao != null && entradaIntegracao.isRgCtrl()) {
            entradaApiTefC.setRg(String.valueOf(entradaIntegracao.getRg()));
            return SUCCESS;
        }
        ControladorPerifericos periferico = dados.getPerifericos();
        String valor = null;
        int caracteresDigitados = 0;
        while (caracteresDigitados == 0) {
            LayoutDisplay layoutDisplay = new LayoutDisplay(inter.getMessage("CAPRG_TITLE"));
            EventoTeclado eventoTeclado = (EventoTeclado)periferico.capturaDado(layoutDisplay, ConstantesApiAc.CAP_RG);
            if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                return USER_CANCEL;
            }
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            valor = eventoTeclado.getStringLida().substring(num);
            caracteresDigitados = valor.length();
            if (caracteresDigitados <= 0) continue;
            try {
                entradaApiTefC.setRg(valor);
            }
            catch (Exception e) {
                caracteresDigitados = 0;
            }
        }
        return SUCCESS;
    }
}

