/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class MicCapturaTipoIdentificacaoDotz {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dados) throws ExcecaoNaoLocal {
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        if (entrada.getTipoIdentificacaoDotz() > 0) {
            return FILLED;
        }
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (entradaIntegracao != null && entradaIntegracao.isTipoDocumentoCtrl() && entradaIntegracao.getTipoDocumento() == 2) {
            this.logger.log("INFO", "Considerando tipo do documento CPF informado na integra\u00e7\u00e3o");
            entrada.setTipoIdentificacaoDotz(1);
            return SUCCESS;
        }
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("CAPTIPIDECLI_TITLE"), true);
        layoutMenu.addItem(new ItemMenu(inter.getMessage("CAPTIPIDECLI_CPF"), "1"));
        layoutMenu.addItem(new ItemMenu(inter.getMessage("CAPTIPIDECLI_CARTAO_DOTZ"), "2"));
        int opcao = perifericos.imprimeMenu(layoutMenu);
        if (opcao == -1) {
            return USER_CANCEL;
        }
        switch (opcao) {
            case 1: {
                entrada.setTipoIdentificacaoDotz(1);
                break;
            }
            case 2: {
                entrada.setTipoIdentificacaoDotz(2);
            }
        }
        return SUCCESS;
    }
}

