/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.DadosConfirmacaoDesfazimento;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.util.PersistService;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class MicConfirmaOperacaoPreVenda {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String ERROR_AC = "ERROR_AC";
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dados) throws ExcecaoApiAc {
        String key = "";
        if (Contexto.getContexto().getEntradaIntegracao() == null) {
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5303, "NUMERO TRANS INVALIDO"));
            return ERROR_AC;
        }
        key = String.valueOf(Contexto.getContexto().getEntradaIntegracao().getNumeroTransacao());
        EntradaApiTefC entrada = null;
        ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
        IdentApiTefC identApitefC = new IdentApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        boolean multiTerminal = entradaIntegracao != null && entradaIntegracao.isMultiTerminal();
        boolean multiEC = config.isMultiEC();
        IdentTerminal identTerminal = null;
        identTerminal = entradaIntegracao != null && (multiTerminal || multiEC) ? Contexto.getContexto().getEntradaIntegracao().getIdentTerminal() : new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
        identApitefC.setNumeroEstabelecimento(identTerminal.getEstabelecimento());
        identApitefC.setNumeroLoja(identTerminal.getLoja());
        identApitefC.setNumeroPdv(identTerminal.getTerminal());
        identApitefC.setNumeroSites(String.valueOf(config.getNumeroSites()));
        identApitefC.setQuantidadeVias(config.getQuantidadeVias());
        entrada = new EntradaApiTefC();
        entrada.setOperacao(this.getCodigoTransacao());
        DadosConfirmacaoDesfazimento entradaPersistida = null;
        try {
            entradaPersistida = (DadosConfirmacaoDesfazimento)PersistService.getInstance().load(key, identTerminal);
            entrada.setNumeroTransacao(entradaPersistida.getNumeroTransacao());
            entrada.setDataCliente(entradaPersistida.getDataCliente());
            entrada.setNumeroSeriePin(entradaPersistida.getNumeroSeriePin());
            entrada.setTimeoutCtf(entradaPersistida.getTimeout());
            entrada.setTimestamp(entradaPersistida.getTimestamp());
            entrada.setDadosFinaisChip(entradaPersistida.getDadosFinaisChip());
            entrada.setIssuerScriptResult(entradaPersistida.getIssuerScriptResult());
        }
        catch (ExcecaoApiAc e) {
            this.logger.error("n\u00e3o foi poss\u00edvel recuperar os dados da transa\u00e7\u00e3o para realizar a confirma\u00e7\u00e3o no terminal " + identTerminal, e);
        }
        SaidaApiTefC saida = dados.getApitef().confirmacao(identApitefC, entrada);
        Contexto.getContexto().setSaidaApiTefC(saida);
        if (saida.getRetorno() != 0 && saida.getRetorno() != 10 && saida.getRetorno() != 13) {
            this.logger.error("n\u00e3o foi poss\u00edvel confirmar a pr\u00e9-venda da transa\u00e7\u00e3o " + key + " para o terminal " + identTerminal + ". verifique os arquivos de controle da Apiwebctf.");
            return ERROR;
        }
        String numeroTransacaoString = entradaPersistida != null ? String.valueOf(entradaPersistida.getNumeroTransacao()) : "<null>";
        this.logger.debug("confirma\u00e7\u00e3o da transa\u00e7\u00e3o de pr\u00e9-venda " + numeroTransacaoString + " para o terminal " + identTerminal + " realizada com sucesso.");
        if (saida.getRetorno() == 10) {
            this.logger.warn("apitef retornou erro de comunicacao, porem, a transacao esta confirmada no ctfclient e sera sincronizada na proxima transacao.");
            this.logger.warn("retorno: 10, cod_erro: " + saida.getCodigoErro() + ", alterado para retorno: 0, cod_erro: 0000");
            saida.setRetorno(0);
            saida.setCodigoErro(0);
        }
        return SUCCESS;
    }

    protected String getCodigoTransacao() throws IllegalStateException {
        return "90";
    }
}

