/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.model.Premio;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessLeituraPin;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.ControladorModeloPinPad;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class MicConfirmacaoResgatePremio {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_INTERNAL = "USER_CANCEL_INTERNAL";
    public static final String MSG_CONFIRMA_PINPAD = "CONFIRMA?";
    private InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dados) throws ExcecaoPerifericos {
        ControladorPerifericos periferico = dados.getPerifericos();
        PinEMV pin = periferico.getPin();
        String retorno = this.confirmaTelefone(dados, pin);
        return retorno;
    }

    private String confirmaTelefone(Process dados, PinEMV pin) throws ExcecaoPerifericos {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        Criptografia criptografia = null;
        try {
            criptografia = ControladorModeloPinPad.getInstance().getCriptografia(pin);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Premio premio = entradaApiTefC.getPremio();
        String mensagemPin = premio.getDescricao().length() > 16 ? premio.getDescricao().substring(0, 16) : StringUtil.completaString(premio.getDescricao(), 16, ' ', 4);
        mensagemPin = mensagemPin + "RESGATAR?   " + StringUtil.completaString(String.valueOf(entradaApiTefC.getQuantidadePremios()), 4, ' ', 3);
        ProcessManager processManager = ProcessManager.getInstance();
        ProcessLeituraPin processLeituraPin = new ProcessLeituraPin(criptografia, null, false, false);
        processLeituraPin.setActiveDialogUserCancel(false);
        processLeituraPin.setTituloAguardaPin(this.inter.getMessage("CONRESPRE_TITLE_TELA"));
        dados.getPerifericos().getPin().setMsgDisplay(mensagemPin);
        processLeituraPin.setTipoLeituraPin(3);
        try {
            processManager.subProcess(dados.getIdProcess(), processLeituraPin);
            if (processLeituraPin.getState() == 3) {
                entradaApiTefC.setQuantidadePremios(0);
                return USER_CANCEL;
            }
            if (processLeituraPin.getState() == 5) {
                entradaApiTefC.setQuantidadePremios(0);
                return USER_CANCEL_INTERNAL;
            }
            if (processLeituraPin.getState() == 1) {
                return ERROR;
            }
            if (processLeituraPin.getTeclaFuncaoPressionada() == 0) {
                return SUCCESS;
            }
            return USER_CANCEL;
        }
        catch (Exception e) {
            this.logger.log(ERROR, e.getMessage(), e);
            if (Contexto.getContexto().getErroIntegracao() == null) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5331, "TENTE NOVAMENTE"));
            }
            return ERROR;
        }
    }
}

