/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.ProcessConsultaFinanciamentoCredito;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.TaxaJuroParcela;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.text.DecimalFormat;
import java.util.List;

public class MicConsultaFinanciamento {
    private ILogger logger = CTFClientLogger.getCTFClient();
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String UNECESSARY = "UNECESSARY";

    public String execute(Process dados) {
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (saidaApiTefC != null && saidaApiTefC.isConsultaFinanciamento()) {
            if (!this.isPlanoValido()) {
                this.logger.warn("consulta disponivel apenas para plano a prazo");
                return UNECESSARY;
            }
            ProcessManager processManager = ProcessManager.getInstance();
            ProcessConsultaFinanciamentoCredito process = new ProcessConsultaFinanciamentoCredito();
            try {
                processManager.subProcess(dados.getIdProcess(), process);
                if ((process.getState() == 0 || process.getState() == 2) && Contexto.getContexto().getSaidaApiTefC() != null && Contexto.getContexto().getSaidaApiTefC().getRetorno() == 0) {
                    List<TaxaJuroParcela> parcelas = Contexto.getContexto().getParcelas();
                    if (parcelas != null && parcelas.size() > 0) {
                        TaxaJuroParcela parcela = parcelas.iterator().next();
                        DecimalFormat formatNumber = new DecimalFormat("#,##0.00");
                        String parcelaFormatada = StringUtil.completaString(parcela.getNumero() + "", 2, '0', 3);
                        LayoutDisplay display = new LayoutDisplay();
                        display.addLinha(new Linha("CONFIRME OS DADOS DO FINANCIAMENTO"));
                        display.addLinha(new Linha("QTDE PARCELAS: " + parcelaFormatada, 0, 1));
                        display.addLinha(new Linha("VALOR PARCELA: " + formatNumber.format(parcela.getValor())));
                        display.addLinha(new Linha("TAXA JUROS: " + formatNumber.format(parcela.getTaxaJuros())));
                        display.addLinha(new Linha("VALOR TOTAL: " + formatNumber.format(parcela.getValorTotal())));
                        ControladorPerifericos perifericos = dados.getPerifericos();
                        perifericos.confirmaDado(display);
                    }
                    Contexto.getContexto().setSaidaApiTefC(saidaApiTefC);
                    return SUCESS;
                }
                if (process.getState() == 3) {
                    Contexto.getContexto().setSaidaApiTefC(saidaApiTefC);
                    return USERCANCEL;
                }
                return ERRO;
            }
            catch (Exception e) {
                this.logger.log("ERROR", e.getMessage(), e);
                if (Contexto.getContexto().getErroIntegracao() == null) {
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5331, "TENTE NOVAMENTE"));
                }
                return ERRO;
            }
        }
        return UNECESSARY;
    }

    public boolean isPlanoValido() {
        return Plano.isPlanoParcelado(Contexto.getContexto().getPlano());
    }
}

