/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.DadosConfirmacaoDesfazimento;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.util.PersistService;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.util.ArrayList;
import java.util.Collection;

public class MicDesfazimentoOperacaoGeral {
    public static final String SUCESS = "SUCESS";
    public static final String FAIL = "FAIL";
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dado) throws ExcecaoApiAc {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        IdentApiTefC ident = Contexto.getContexto().getIdentApiTefC();
        IdentTerminal identTerminal = new IdentTerminal(ident.getNumeroEstabelecimento(), ident.getNumeroLoja(), ident.getNumeroPdv());
        try {
            int i;
            Collection dadosEntrada = PersistService.getInstance().loadAll(identTerminal);
            if (dadosEntrada == null || dadosEntrada.isEmpty()) {
                SaidaApiTefC saida = new SaidaApiTefC();
                saida.setRetorno(0);
                Contexto.getContexto().setSaidaApiTefC(saida);
                return SUCESS;
            }
            ArrayList arrayContrario = dadosEntrada instanceof ArrayList ? (ArrayList)dadosEntrada : new ArrayList(dadosEntrada);
            DadosConfirmacaoDesfazimento dadosDesfazimento = null;
            SaidaApiTefC saida = null;
            for (i = arrayContrario.size() - 1; i >= 0; --i) {
                dadosDesfazimento = (DadosConfirmacaoDesfazimento)arrayContrario.get(i);
                entradaApiTefC.setOperacao(dadosDesfazimento.getOperacao());
                entradaApiTefC.setNumeroTransacao(i + 1);
                entradaApiTefC.setDataCliente(dadosDesfazimento.getDataCliente());
                entradaApiTefC.setNumeroSeriePin(dadosDesfazimento.getNumeroSeriePin());
                entradaApiTefC.setTimeoutCtf(dadosDesfazimento.getTimeout());
                entradaApiTefC.setTimestamp(dadosDesfazimento.getTimestamp());
                if (dadosDesfazimento.getTipoResposta() != null && !dadosDesfazimento.getTipoResposta().equals("")) {
                    entradaApiTefC.setTipoResposta(dadosDesfazimento.getTipoResposta().charAt(0));
                }
                entradaApiTefC.setDadosFinaisChip(dadosDesfazimento.getDadosFinaisChip());
                entradaApiTefC.setIssuerScriptResult(dadosDesfazimento.getIssuerScriptResult());
                if (dadosDesfazimento.getApplicationExpirationDate() != null) {
                    entradaApiTefC.setApplicationExpirationDate(dadosDesfazimento.getApplicationExpirationDate());
                }
                entradaApiTefC.setMotivoDesfazimento(11);
                saida = dado.getApitef().desfazimento(ident, entradaApiTefC);
                if (saida.getRetorno() != 0) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("defazimento da transa\u00e7\u00e3o " + dadosDesfazimento.getNumeroTransacao() + " para o terminal " + identTerminal + " realizada com sucesso.");
                }
                PersistService.getInstance().remove(Integer.toString(dadosDesfazimento.getNumeroTransacao()), identTerminal);
            }
            Contexto.getContexto().setSaidaApiTefC(saida);
            if (saida.getRetorno() != 0) {
                this.logger.error("n\u00e3o foi poss\u00edvel desfazer a transa\u00e7\u00e3o " + (i + 1) + " (" + dadosDesfazimento.getNumeroTransacao() + ") para o terminal " + identTerminal + ". verifique os arquivos de controle da Apiwebctf.");
                return FAIL;
            }
        }
        catch (ExcecaoApiAc e) {
            this.logger.error("n\u00e3o foi poss\u00edvel recuperar os dados da transa\u00e7\u00e3o para realizar o desfazimento total no terminal " + identTerminal, e);
            throw e;
        }
        return SUCESS;
    }
}

