/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.PinInfo;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class MicDesfazimentoOperacaoTransacaoCorrente {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dados) throws ExcecaoApiAc {
        PinInfo pinInfo;
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        IdentApiTefC ident = Contexto.getContexto().getIdentApiTefC();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaOriginal = Contexto.getContexto().getSaidaApiTefC();
        if (saidaOriginal != null) {
            entradaApiTefC.setNsuCtfTransacaoOriginal(saidaOriginal.getNsuCTF());
        }
        if (entradaApiTefC.getStatusComunicacaoHost() == 0 && (pinInfo = Contexto.getContexto().getPinInfo()) != null) {
            entradaApiTefC.setDecisaoChip(StringUtil.completaString(pinInfo.getDecisaoFinishChip() + "", 1, ' ', 3).toCharArray()[0]);
        }
        if (entradaApiTefC.getMotivoDesfazimento() != 0) {
            this.logger.log("INFO", "Motivo do desfazimento: " + entradaApiTefC.getMotivoDesfazimento());
        }
        this.logger.info("enviando transa\u00e7\u00e3o de desfazimento");
        SaidaApiTefC saida = dados.getApitef().desfazimento(ident, entradaApiTefC);
        this.logger.info("transa\u00e7\u00e3o de desfazimento enviada: " + saida.getRetorno());
        if (entradaIntegracao != null && (entradaIntegracao.getOperacao() == 7 || entradaIntegracao.getOperacao() == 191)) {
            Contexto.getContexto().setSaidaApiTefC(saida);
        }
        this.logger.log("DEBUG", "N\u00famero da transa\u00e7\u00e3o: " + entradaApiTefC.getNumeroTransacao());
        this.logger.log("DEBUG", "Motivo da rejei\u00e7\u00e3o: " + entradaApiTefC.getTipoResposta());
        if (entradaApiTefC.getTipoResposta() != null && entradaApiTefC.getTipoResposta().equals("2")) {
            String mensagem = (Contexto.getContexto().getCartao() == Cartao.CHIP || Contexto.getContexto().getCartao() == Cartao.CONTACTLESS_EMV) && Integer.parseInt(entradaApiTefC.getCodigoRedeAdquirenteChip()) == 2 ? "TRANSACAO NEGADA LIGUE EMISSOR" : "TRANS. NAO AUT. PELO CARTAO";
            String mensagemFormatada = StringUtil.completaString("" + mensagem.length(), 4, '0', 3);
            Contexto.getContexto().getSaidaApiTefC().setDisplayCTF(mensagemFormatada + mensagem);
            Contexto.getContexto().getSaidaApiTefC().setRetorno(11);
        } else if (Contexto.getContexto().getErrorCode() > 0) {
            String msg = StringUtil.completaString("" + "ERRO NO CARTAO COM CHIP".length(), 4, '0', 3);
            Contexto.getContexto().getSaidaApiTefC().setDisplayCTF(msg + "ERRO NO CARTAO COM CHIP");
            Contexto.getContexto().getSaidaApiTefC().setRetorno(20);
        }
        return SUCCESS;
    }
}

