/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.model.Produto;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractEnvio1F;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class MicEnvio1FConsultaAvsMultiTerminal
extends MicAbstractEnvio1F {
    private static final String CODIGO_TRANSACAO = "D6";
    private ILogger logger = CTFClientLogger.getCTFClient();

    @Override
    public String execute(Process dados) throws ExcecaoApiAc {
        Produto[] produtos;
        String retorno;
        if (Contexto.getContexto().getCartao() == Cartao.DIGITADO) {
            Calendar calender = GregorianCalendar.getInstance();
            calender.setTime(new Date());
            calender.add(5, 1);
            Contexto.getContexto().getEntradaApiTefC().setDataVencimento(calender.getTime());
        }
        if ((retorno = super.execute(dados)).equals("SUCESS") && (produtos = Contexto.getContexto().getSaidaApiTefC().getProdutos()) != null && produtos.length != 0) {
            if (produtos.length > 1) {
                this.logger.error("N\u00famero de produtos inv\u00e1lido. N\u00e3o \u00e9 poss\u00edvel processar a transa\u00e7\u00e3o");
                CodigoErroIntegracao erroIntegracao = new CodigoErroIntegracao(5306, "OPERACAO  NAO PERMITIDA");
                Contexto.getContexto().setErroIntegracao(erroIntegracao);
                retorno = "ERRO";
            } else {
                Contexto.getContexto().getEntradaApiTefC().setCodigoProduto(produtos[0].getCodigo());
                Contexto.getContexto().getEntradaApiTefC().setFluxoTef(produtos[0].getKeyFluxo());
                Contexto.getContexto().getEntradaApiTefC().setCodigoBandeira(produtos[0].getCodigoBandeira());
            }
        }
        return retorno;
    }

    @Override
    protected String getCodigoTransacao(Process dados1F) throws IllegalStateException {
        return CODIGO_TRANSACAO;
    }
}

