/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractEnvio1F;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class MicEnvio1FMenuDinamico
extends MicAbstractEnvio1F {
    public static final String UNECESSARY = "UNECESSARY";
    private ILogger logger = CTFClientLogger.getCTFClient();
    private boolean timeoutCustomizado = false;

    @Override
    public String execute(Process dados) throws ExcecaoApiAc {
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (saidaApiTefC != null && saidaApiTefC.getRetorno() == 0) {
            return UNECESSARY;
        }
        boolean vencimentoDefault = false;
        if (Contexto.getContexto().getCartao() == Cartao.DIGITADO) {
            Calendar calender = GregorianCalendar.getInstance();
            calender.setTime(new Date());
            calender.add(5, 1);
            entrada.setDataVencimento(calender.getTime());
            vencimentoDefault = true;
        }
        if (entradaIntegracao != null && entradaIntegracao.isPermiteAprovacaoValorParcialCtrl()) {
            this.logger.log("INFO", "Pagamento com saldo do voucher (AC): " + entradaIntegracao.isPermiteAprovacaoValorParcial());
            entrada.setPermiteAprovacaoValorParcial(entradaIntegracao.isPermiteAprovacaoValorParcial());
        }
        if (entradaIntegracao != null && entradaIntegracao.isTipoAutorizadoraCtrl()) {
            this.logger.log("INFO", "Tipo da autorizadora: " + entradaIntegracao.getTipoAutorizadora());
            entrada.setTipoAutorizadora(entradaIntegracao.getTipoAutorizadora());
        }
        if (entradaIntegracao != null && entradaIntegracao.isExecutaFinanciamentoAutorizadoraCtrl()) {
            this.logger.log("INFO", "Executa Financiamento Autorizadora: " + entradaIntegracao.isExecutaConsultaFinanciamentoAutorizadora());
            entrada.setExecutaFinanciamentoAutorizadora(entradaIntegracao.isExecutaConsultaFinanciamentoAutorizadora());
            this.timeoutCustomizado = true;
        }
        String retorno = super.execute(dados);
        if (vencimentoDefault) {
            entrada.setDataVencimento(null);
        }
        return retorno;
    }

    @Override
    protected int getTimeout1F() {
        int timeout1F = super.getTimeout1F();
        if (this.timeoutCustomizado) {
            return timeout1F + 15;
        }
        return timeout1F;
    }

    @Override
    protected String getCodigoTransacao(Process dados1F) throws IllegalStateException {
        if ("CREDITO GENERICO".equals(Contexto.getContexto().getTipoOperacao())) {
            if (Contexto.getContexto().getCartao() == Cartao.DIGITADO) {
                return "24";
            }
            return "12";
        }
        if ("DEBITO GENERICO".equals(Contexto.getContexto().getTipoOperacao())) {
            return "10";
        }
        if ("OUTRAS TRANSACOES".equals(Contexto.getContexto().getTipoOperacao())) {
            return "2R";
        }
        if ("VOUCHER GENERICO".equals(Contexto.getContexto().getTipoOperacao())) {
            return "6A";
        }
        if ("OPERACAO CONSULTA CDC COM PARCELA A VISTA".equals(Contexto.getContexto().getTipoOperacao()) || "OPERACAO CONSULTA CDC SEM PARCELA A VISTA".equals(Contexto.getContexto().getTipoOperacao())) {
            return "5C";
        }
        if ("OPERACAO CANCELAMENTO".equals(Contexto.getContexto().getTipoOperacao())) {
            return "2W";
        }
        if ("OPE_DEBITO_CREDIARIO".equals(Contexto.getContexto().getTipoOperacao())) {
            return "GB";
        }
        throw new IllegalStateException("Codigo transa\u00e7\u00e3o n\u00e3o encontrada!");
    }
}

