/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.ControladorEstatistica;
import com.csi.ctfclient.operacoes.model.DadosEstatistica;

public class MicEstatisticaLeituraCartao {
    public static final String SUCESS = "SUCESS";
    private static final int PASSIVEL_FALLBACK = 1;

    public String execute(Process dados) {
        Cartao cartao = Contexto.getContexto().getCartao();
        if (cartao != null && cartao == Cartao.MAGNETICO && Contexto.getContexto().getStatusLeituraCartao() == 1) {
            boolean persistirDados = false;
            try {
                ControladorEstatistica controladorEstatistica = ControladorEstatistica.getInstance();
                DadosEstatistica dadosEstatistica = controladorEstatistica.getDadosEstatistica();
                if (Contexto.getContexto().getTipoOperacao().equals("OPERACAO CREDITO") || Contexto.getContexto().getTipoOperacao().equals("CREDITO GENERICO") || Contexto.getContexto().getTipoOperacao().equals("OPERACAO PRE AUTORIZACAO") || Contexto.getContexto().getTipoOperacao().equals("OPERACAO CONFIRMACAO PRE AUTORIZACAO")) {
                    dadosEstatistica.addFallbackChipCredito();
                    persistirDados = true;
                } else if (Contexto.getContexto().getTipoOperacao().equals("OPERACAO DEBITO") || Contexto.getContexto().getTipoOperacao().equals("DEBITO GENERICO")) {
                    dadosEstatistica.addFallbackChipDebito();
                    persistirDados = true;
                }
                if (persistirDados) {
                    controladorEstatistica.persistirDados(dadosEstatistica);
                }
            }
            catch (ExcecaoApiAc e) {
                e.printStackTrace();
            }
        }
        return SUCESS;
    }
}

