/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CMOSPinPad;
import com.csi.ctfclient.operacoes.model.ControladorTransacaoInicioDia;
import com.csi.ctfclient.operacoes.model.controller.ControladorAIDsGetCard;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.operacoes.model.controller.ControladorMultiEC;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.devices.emvfull.KeyFactory;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class MicExecutaInicioDia {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dados) throws ExcecaoApiAc {
        block15: {
            InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
            EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
            try {
                ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
                ControladorTransacaoInicioDia controlador = new ControladorTransacaoInicioDia();
                boolean multiTerminal = entradaIntegracao != null && entradaIntegracao.isMultiTerminal();
                boolean opInicioDia = entradaIntegracao != null && entradaIntegracao.getOperacao() == 225;
                boolean delivery = entradaIntegracao != null && entradaIntegracao.getCodigoOrigemTransacao() == 1;
                boolean multiEC = config.isMultiEC();
                if (opInicioDia || multiTerminal || delivery) {
                    controlador.executaInicioDia(entradaIntegracao);
                } else {
                    ControladorPerifericos perifericos = dados.getPerifericos();
                    LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("EXEINIDIA_INICIO_DIA"));
                    perifericos.imprimeDisplay(displayModel);
                    if (entradaIntegracao != null && multiEC) {
                        controlador.executaInicioDia(entradaIntegracao);
                    } else {
                        controlador.executaInicioDia();
                    }
                }
                SaidaApiTefC saida = controlador.getSaida();
                if (entradaIntegracao != null && entradaIntegracao.getOperacao() == 225) {
                    Contexto.getContexto().setSaidaApiTefC(saida);
                } else if (saida.getRetorno() > 0) {
                    Contexto.getContexto().atualizaEntradaApiTefC(controlador.getEntrada());
                    Contexto.getContexto().setSaidaApiTefC(saida);
                }
                ControladorPerifericos periferico = dados.getPerifericos();
                PinEMV pin = periferico.getPin();
                if (pin instanceof BibliotecaPinpad) {
                    BibliotecaPinpad pinCompartilhado = (BibliotecaPinpad)pin;
                    ControladorCriptografia.getTabelaCriptografia(pinCompartilhado, saida);
                }
                if (saida.getRetorno() != 0) {
                    return ERRO;
                }
                if (!multiTerminal && ProtocoloBibliotecaCompartilhada.isComunicacaoSegura() && KeyFactory.isChaveLocal()) {
                    KeyFactory.generateKeys();
                }
                Contexto.getContexto().getEntradaApiTefC().setIndiceChaveTerminal(KeyFactory.getIndiceChave());
                if (multiTerminal || !saida.isInformaAIDGetcard()) break block15;
                IdentTerminal identTerminal = null;
                identTerminal = multiEC ? ControladorMultiEC.criarTerminalComumMultiEC(config.getCodigoGrupoMultiEC()) : new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
                ControladorAIDsGetCard controladorAIDsGetCard = ControladorAIDsGetCard.getInstance(identTerminal);
                if (controladorAIDsGetCard.getMapAid() != null) break block15;
                try {
                    if (saida.getTipoBibliotecaPinpad() == 1) {
                        this.logger.info("NECESSITA REALIZAR CARGA DE TABELA - Suporte AIDs Hipercard duplicado");
                        CMOSPinPad.getInstance().solicitarCargaTabelas(saida.getRedeChip());
                    }
                }
                catch (Exception exception) {}
            }
            catch (ExcecaoApiAc e) {
                this.logger.error("n\u00e3o foi poss\u00edvel realizar a transa\u00e7\u00e3o de inicio dia. " + e.getMessage());
                return ERRO;
            }
        }
        return SUCESS;
    }
}

