/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessLeituraPin;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.ControladorModeloPinPad;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.text.ParseException;
import javax.swing.text.MaskFormatter;

public class MicExibeConfirmacaoIdentificacao4All {
    public static final String SUCCESS = "SUCCESS";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_INTERNAL = "USER_CANCEL_INTERNAL";
    public static final String ERROR = "ERROR";
    private static final String MSG_CONFIRMA_PINPAD = "CONFIRMA?";
    private ILogger logger = CTFClientLogger.getCTFClient();
    private InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();

    public String execute(Process dados) throws ExcecaoApiAc {
        String mensagem;
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        if (entrada.getTipoIdentificacao4all() == 1) {
            String mascara = entrada.getTelefoneMovel().length() == 10 ? "(##)####-####" : "(##)#####-####";
            mensagem = MicExibeConfirmacaoIdentificacao4All.maskString(entrada.getTelefoneMovel(), mascara);
        } else if (entrada.getTipoIdentificacao4all() == 2) {
            mensagem = MicExibeConfirmacaoIdentificacao4All.maskString(entrada.getCpf(), "###.###.###-##");
        } else {
            return ERROR;
        }
        ControladorPerifericos periferico = dados.getPerifericos();
        PinEMV pin = periferico.getPin();
        String retorno = this.confirmaDado(dados, pin, entrada, mensagem);
        return retorno;
    }

    private String confirmaDado(Process dados, PinEMV pin, EntradaApiTefC entrada, String mensagem) throws ExcecaoPerifericos {
        Criptografia criptografia = null;
        try {
            criptografia = ControladorModeloPinPad.getInstance().getCriptografia(pin);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String mensagemPin = StringUtil.completaString(mensagem, 16, ' ', 4) + MSG_CONFIRMA_PINPAD;
        ProcessManager processManager = ProcessManager.getInstance();
        ProcessLeituraPin processLeituraPin = new ProcessLeituraPin(criptografia, null, false, false);
        processLeituraPin.setActiveDialogUserCancel(false);
        processLeituraPin.setTituloAguardaPin(this.inter.getMessage("EXICONTEL_MSG_CONFIRMACAO"));
        dados.getPerifericos().getPin().setMsgDisplay(mensagemPin);
        processLeituraPin.setTipoLeituraPin(3);
        try {
            processManager.subProcess(dados.getIdProcess(), processLeituraPin);
            if (processLeituraPin.getState() == 3 || processLeituraPin.getState() == 5) {
                Contexto.getContexto().setErroIntegracao(null);
                entrada.setTipoIdentificacao4all(-1);
                entrada.setTelefoneMovel(null);
                entrada.setCpf(null);
                if (processLeituraPin.getState() == 3) {
                    return USER_CANCEL;
                }
                return USER_CANCEL_INTERNAL;
            }
            if (processLeituraPin.getState() == 1) {
                return ERROR;
            }
            if (processLeituraPin.getTeclaFuncaoPressionada() != 0) {
                return "RERUN";
            }
        }
        catch (Exception e) {
            this.logger.log(ERROR, e.getMessage(), e);
            if (Contexto.getContexto().getErroIntegracao() == null) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5331, "TENTE NOVAMENTE"));
            }
            return ERROR;
        }
        return SUCCESS;
    }

    private static String maskString(String value, String pattern) {
        try {
            MaskFormatter mf = new MaskFormatter(pattern);
            mf.setValueContainsLiteralCharacters(false);
            return mf.valueToString(value);
        }
        catch (ParseException ex) {
            return value;
        }
    }
}

