/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessLeituraPin;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.ControladorModeloPinPad;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicExibeConfirmacaoTelefone {
    public static final String SUCESS = "SUCESS";
    public static final String ERROR = "ERROR";
    public static final String UNNECESSARY = "UNNECESSARY";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_INTERNAL = "USER_CANCEL_INTERNAL";
    public static final String USER_CANCEL_AC = "USER_CANCEL_AC";
    public static final String CONFIRM_AGAIN = "CONFIRM_AGAIN";
    public static final String MSG_CONFIRMA_PINPAD = "CONFIRMA?";
    private InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();

    public String execute(Process dados) throws ExcecaoApiAc {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        boolean telefoneConfirmado = Contexto.getContexto().isTelefoneConfirmado();
        if (!ControladorConfCTFClient.getInstance().getConfig().isConfirmaDddTelefone()) {
            return UNNECESSARY;
        }
        if (telefoneConfirmado) {
            return UNNECESSARY;
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().isDddCtrl() && Contexto.getContexto().getEntradaIntegracao().isTelefoneCtrl()) {
            return UNNECESSARY;
        }
        if (entradaApiTefC.getDdd() == null && entradaApiTefC.getTelefone() == null) {
            return ERROR;
        }
        ControladorPerifericos periferico = dados.getPerifericos();
        PinEMV pin = periferico.getPin();
        String retorno = this.confirmaTelefone(dados, entradaApiTefC, pin);
        return retorno;
    }

    private String confirmaTelefone(Process dados, EntradaApiTefC entradaApiTefC, PinEMV pin) throws ExcecaoPerifericos {
        Criptografia criptografia = null;
        try {
            criptografia = ControladorModeloPinPad.getInstance().getCriptografia(pin);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String mensagemPin = StringUtil.completaString("(" + entradaApiTefC.getDdd() + ")" + entradaApiTefC.getTelefone().substring(0, entradaApiTefC.getTelefone().length() - 4) + "-" + entradaApiTefC.getTelefone().substring(entradaApiTefC.getTelefone().length() - 4, entradaApiTefC.getTelefone().length()), 16, ' ', 4) + MSG_CONFIRMA_PINPAD;
        ProcessManager processManager = ProcessManager.getInstance();
        ProcessLeituraPin processLeituraPin = new ProcessLeituraPin(criptografia, null, false, false);
        processLeituraPin.setActiveDialogUserCancel(false);
        processLeituraPin.setTituloAguardaPin(this.inter.getMessage("EXICONTEL_MSG_CONFIRMACAO"));
        dados.getPerifericos().getPin().setMsgDisplay(mensagemPin);
        processLeituraPin.setTipoLeituraPin(3);
        try {
            processManager.subProcess(dados.getIdProcess(), processLeituraPin);
            if (processLeituraPin.getState() == 3 || processLeituraPin.getState() == 5) {
                if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().isDddCtrl() && Contexto.getContexto().getEntradaIntegracao().isTelefoneCtrl()) {
                    return USER_CANCEL_AC;
                }
                entradaApiTefC.setDdd(null);
                entradaApiTefC.setTelefone(null);
                if (processLeituraPin.getState() == 3) {
                    Contexto.getContexto().setErroIntegracao(null);
                    return USER_CANCEL;
                }
                Contexto.getContexto().setErroIntegracao(null);
                return USER_CANCEL_INTERNAL;
            }
            if (processLeituraPin.getState() == 1) {
                return ERROR;
            }
            if (processLeituraPin.getTeclaFuncaoPressionada() != 0) {
                return CONFIRM_AGAIN;
            }
        }
        catch (Exception e) {
            return ERROR;
        }
        return SUCESS;
    }
}

