/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.RemoveCardMessage;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaFinishChipEMV;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class MicFinishChip {
    public static final String SUCESS_APROVADA = "SUCESS_APROVADA";
    public static final String SUCCESS_APROVADA_OFF = "SUCCESS_APROVADA_OFF";
    public static final String SUCESS_NEGADA_CARTAO = "SUCESS_NEGADA_CARTAO";
    public static final String NEGADA_CARTAO_OFF = "NEGADA_CARTAO_OFF";
    public static final String SUCESS_NEGADA_HOST = "SUCESS_NEGADA_HOST";
    public static final String SUCCESS_NEGADA_HOST_REENVIO = "SUCCESS_NEGADA_HOST_REENVIO";
    public static final String NOTREQUIRED = "NOTREQUIRED";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String ERRO = "ERRO";
    public static final String ERRO_PIN_PAD = "ERRO_PIN_PAD";
    public static final String ERRO_FINISH_CHIP = "ERRO_FINISH_CHIP";
    public static final String MSG_NEGADA_CARTAO = "TRANSACAO NAO AUTORIZADA          PELO CARTAO";
    private ILogger logger = CTFClientLogger.getCTFClient();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String execute(Process dados) throws ExcecaoPerifericos {
        ControladorPerifericos perifericos = dados.getPerifericos();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (!saidaApiTefC.isCapturaDadosChip()) return NOTREQUIRED;
        if (saidaApiTefC.isFluxoEMVSemFinishChip()) return NOTREQUIRED;
        if (Contexto.getContexto().getPinInfo() == null) {
            return NOTREQUIRED;
        }
        if (Contexto.getContexto().getPinInfo().getDecisaoTomada() == '1') {
            Contexto.getContexto().setRemoveCardMessage(RemoveCardMessage.MSG_TRANS_NAO_AUT_CARTAO);
            return UNECESSARY;
        }
        PinEMV pinEMV = perifericos.getPin();
        if (saidaApiTefC.getRetorno() != 0 && saidaApiTefC.getRetorno() != 1 && saidaApiTefC.getRetorno() != 5) {
            if (saidaApiTefC.getRetorno() == 11) return UNECESSARY;
            if (saidaApiTefC.getStatusComunicacao() == 0) return UNECESSARY;
        }
        if (saidaApiTefC.getStatusComunicacao() == 0) {
            pinEMV.setComunicacaoHost(saidaApiTefC.getStatusComunicacao());
            pinEMV.setTipoEmissor(saidaApiTefC.getTipoEmissor());
            pinEMV.setAuthRespCode(saidaApiTefC.getCodigoRespostaAutorizadora());
            pinEMV.setCampo55(saidaApiTefC.getDadosRespostaChip());
            pinEMV.setDadosRestantes("");
            pinEMV.setTags(saidaApiTefC.getTagsFinais());
        } else {
            pinEMV.setComunicacaoHost(1);
            pinEMV.setTipoEmissor(0);
            pinEMV.setAuthRespCode("00");
            pinEMV.setCampo55("");
            pinEMV.setDadosRestantes("");
            pinEMV.setTags(Contexto.getContexto().getTagsMandatorias());
        }
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        SaidaFinishChipEMV chipEMV = null;
        try {
            chipEMV = pinEMV.finishChip();
            if (chipEMV.getRetorno() > 2) {
                Contexto.getContexto().setRemoveCardMessage(chipEMV.getRetorno() + " - ERRO PIN PAD");
                return ERRO_PIN_PAD;
            }
            this.logger.log("DEBUG", "Decis\u00e3o FinishiChip: " + chipEMV.getDecisao());
            Contexto.getContexto().getPinInfo().setDecisaoFinishChip(chipEMV.getDecisao());
            if (pinEMV.getComunicacaoHost() == 1) {
                entrada.setDadosFinaisChip(chipEMV.getDadosFinais());
                entrada.setDecisaoChip(StringUtil.completaString(chipEMV.getDecisao() + "", 1, ' ', 3).toCharArray()[0]);
                entrada.setStatusComunicacaoHost(pinEMV.getComunicacaoHost());
                entrada.setDadosChip(null);
            }
            switch (chipEMV.getDecisao()) {
                case 0: {
                    entrada.setDadosFinaisChip(chipEMV.getDadosFinais());
                    entrada.setIssuerScriptResult(chipEMV.getIssuerScriptResults());
                    Contexto.getContexto().setRemoveCardMessage(RemoveCardMessage.MSG_TRANS_APROVADA);
                    if (pinEMV.getComunicacaoHost() != 1) return SUCESS_APROVADA;
                    return SUCCESS_APROVADA_OFF;
                }
                case 1: {
                    entrada.setTipoResposta('2');
                    entrada.setDadosFinaisChip(chipEMV.getDadosFinais());
                    entrada.setIssuerScriptResult(chipEMV.getIssuerScriptResults());
                    if (pinEMV.getComunicacaoHost() == 1) {
                        entrada.setStatusComunicacaoHost(pinEMV.getComunicacaoHost());
                    }
                    int redeChip = Integer.parseInt(entrada.getCodigoRedeAdquirenteChip());
                    if (saidaApiTefC.getRetorno() != 5 && saidaApiTefC.getRetorno() != 1) {
                        if (redeChip == 2) {
                            Contexto.getContexto().setFinishChipMessage("TRANSACAO NEGADA LIGUE EMISSOR");
                        } else {
                            Contexto.getContexto().setFinishChipMessage("TRANS. NAO AUT. PELO CARTAO");
                        }
                    }
                    if (redeChip == 2) {
                        Contexto.getContexto().setRemoveCardMessage(RemoveCardMessage.REMCAR_TRANS_NAO_AUT_CARTAO_LIGUE_EMISSOR);
                    } else {
                        Contexto.getContexto().setRemoveCardMessage(RemoveCardMessage.MSG_TRANS_NAO_AUT_CARTAO);
                    }
                    entrada.setMotivoDesfazimento(2);
                    if (pinEMV.getComunicacaoHost() != 1) {
                        return SUCESS_NEGADA_CARTAO;
                    }
                    if (!entrada.getCodigoRedeAdquirenteChip().equals("03")) return NEGADA_CARTAO_OFF;
                    Contexto.getContexto().setRemoveCardMessage("TENTE DE NOVO-TO");
                    return NEGADA_CARTAO_OFF;
                }
                case 2: {
                    if (saidaApiTefC.getMensagemDisplayPin().trim().equals("")) {
                        Contexto.getContexto().setRemoveCardMessage(RemoveCardMessage.MSG_TRANS_NAO_APROV);
                    }
                    if (!saidaApiTefC.isReenvioNegadaHost()) return SUCESS_NEGADA_HOST;
                    if (chipEMV.getDadosFinais() == null || chipEMV.getDadosFinais().length() <= 0) {
                        if (chipEMV.getIssuerScriptResults() == null) return SUCESS_NEGADA_HOST;
                        if (chipEMV.getIssuerScriptResults().length() <= 0) return SUCESS_NEGADA_HOST;
                    }
                    entrada.setDadosFinaisChip(chipEMV.getDadosFinais());
                    entrada.setIssuerScriptResult(chipEMV.getIssuerScriptResults());
                    return SUCCESS_NEGADA_HOST_REENVIO;
                }
            }
            return ERRO;
        }
        catch (Exception e) {
            this.logger.log("ERROR", e.getMessage(), e);
            if (e instanceof ExcecaoPerifericos && Contexto.getContexto().getSaidaApiTefC().getRetorno() == 0) {
                ExcecaoPerifericos erroPeriferico = (ExcecaoPerifericos)e;
                Contexto.getContexto().setErrorCode(erroPeriferico.getCodigoErroOriginal());
                entrada.setMotivoDesfazimento(2);
                return ERRO_FINISH_CHIP;
            }
            if (Contexto.getContexto().getErroIntegracao() != null) return ERRO;
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5331, "TENTE NOVAMENTE"));
            return ERRO;
        }
    }
}

