/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.TabelaCriptografia;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.RegistroCriptografia;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.devices.emvfull.LeitorCartaoBibliotecaCompartilhada;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class MicFormataIdentificacaoPagamentoFatura {
    public static final String SUCCESS = "SUCCESS";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String ERROR_AC = "ERROR_AC";
    public static final int IDENTIFICACAO_PAGAMENTO_FATURA_CODIGO_BARRAS = 1;
    public static final int IDENTIFICACAO_PAGAMENTO_FATURA_CPF = 2;
    public static final int IDENTIFICACAO_PAGAMENTO_FATURA_CARTAO = 3;
    public static final int IDENTIFICACAO_PAGAMENTO_FATURA_OUTROS = 4;
    private ILogger logger = CTFClientLogger.getCTFClient();

    /*
     * Unable to fully structure code
     */
    public String execute(Process dados) throws ExcecaoPerifericos {
        entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        entrada = Contexto.getContexto().getEntradaApiTefC();
        saida = Contexto.getContexto().getSaidaApiTefC();
        perifericos = dados.getPerifericos();
        v0 = connectedPin = perifericos.getPin() != null;
        if (entradaIntegracao == null || !entradaIntegracao.isTipoIdentificacaoPagamentoFaturaCtrl()) ** GOTO lbl26
        if (entradaIntegracao.getTipoIdentificacaoPagamentoFatura() != 1 && entradaIntegracao.getTipoIdentificacaoPagamentoFatura() != 2 && entradaIntegracao.getTipoIdentificacaoPagamentoFatura() != 3 && entradaIntegracao.getTipoIdentificacaoPagamentoFatura() != 4) ** GOTO lbl23
        if (entradaIntegracao.isIdentificacaoPagamentoFaturaCtrl() && entradaIntegracao.getIdentificacaoPagamentoFatura().length() > 0) {
            if (connectedPin && perifericos.getPin().isBibliotecaEMV() && saida.isCriptografiaCartao()) {
                try {
                    Double.parseDouble(entradaIntegracao.getIdentificacaoPagamentoFatura());
                }
                catch (NumberFormatException e) {
                    this.logger.log("ERROR", "Identificador de pagamento n\u00e3o num\u00e9rico");
                    this.logger.log("INFO", "Identificador fatura: '" + entradaIntegracao.getIdentificacaoPagamentoFatura() + "'");
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5396, "IDENTIFICACAO PAGAMENTO FATURA NAO NUMERICO"));
                    return "ERROR_AC";
                }
            }
        } else {
            this.logger.log("ERROR", "Identificador de pagamento inv\u00e1lido");
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5396, "IDENTIFICACAO PAGAMENTO FATURA INVALIDO"));
            return "ERROR_AC";
lbl23:
            // 1 sources

            this.logger.log("ERROR", "Tipo de identificador inv\u00e1lido");
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5396, "TIPO DE IDENTIFICACAO PAGAMENTO FATURA INVALIDO: " + entradaIntegracao.getTipoIdentificacaoPagamentoFatura()));
            return "ERROR_AC";
lbl26:
            // 1 sources

            return "UNECESSARY";
        }
        bufferCriptografar = entradaIntegracao.getIdentificacaoPagamentoFatura();
        entrada.setTipoIdentificacaoPagamentoFatura(entradaIntegracao.getTipoIdentificacaoPagamentoFatura());
        if (connectedPin && perifericos.getPin().isBibliotecaEMV() && saida.isCriptografiaCartao()) {
            this.logger.log("INFO", "Criptografar o identificador da fatura");
            bufferCompletar = "";
            if (bufferCriptografar.length() < 16) {
                buffer16 = StringUtil.completaString(bufferCriptografar, 16, 'F', 4);
            } else {
                if (bufferCriptografar.length() > 16) {
                    bufferCompletar = bufferCriptografar.substring(16, bufferCriptografar.length());
                }
                buffer16 = bufferCriptografar.substring(0, 16);
            }
            if (ProtocoloBibliotecaCompartilhada.isComunicacaoSegura()) {
                try {
                    buffer16 = LeitorCartaoBibliotecaCompartilhada.descriptografaPAN(buffer16, false);
                }
                catch (Exception e) {
                    this.logger.log("ERROR", "Erro ao descriptografar o identificador da fatura uso na EncryptBuffer", e);
                }
            }
            cript = this.criptografaDados(dados, buffer16, saida);
            identificadorFatura = cript + bufferCompletar;
        } else {
            this.logger.log("INFO", "Enviar o identificador da fatura aberto");
            identificadorFatura = bufferCriptografar;
        }
        entrada.setIdentificacaoPagamentoFatura(identificadorFatura);
        return "SUCCESS";
    }

    private String criptografaDados(Process dado, String value, SaidaApiTefC saida) throws ExcecaoPerifericos {
        ControladorPerifericos periferico = dado.getPerifericos();
        PinEMV pin = periferico.getPin();
        if (pin instanceof BibliotecaPinpad) {
            BibliotecaPinpad pinCompartilhado = (BibliotecaPinpad)pin;
            TabelaCriptografia tabelaCriptografia = ControladorCriptografia.getTabelaCriptografia();
            RegistroCriptografia registroCriptografia = tabelaCriptografia.getCriptografiaDadosPrincipal();
            int modoCriptografia = registroCriptografia.getAlgoritmo();
            String workingKey = StringUtil.completaString(registroCriptografia.getWorkingKey().trim(), 32, '0', false);
            int indiceCriptografia = registroCriptografia.getIndiceMasterKey() == 42 ? 0 : registroCriptografia.getIndiceMasterKey() & 0xF;
            this.logger.log("DEBUG", "Criptografia: Indice: " + indiceCriptografia + ", Modo: " + modoCriptografia + ", Working Key: " + workingKey);
            if (modoCriptografia == 0) {
                workingKey = StringUtil.completaString(workingKey, 32, '0', 4);
            }
            return pinCompartilhado.encryptBuffer(modoCriptografia, indiceCriptografia, workingKey, value);
        }
        throw new ExcecaoPerifericos(null, "Erro na criptografia do cart\u00e3o");
    }
}

