/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.model.Aid;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoInteiroInvalido;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CMOSPinPad;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.operacoes.model.GetInfo;
import com.csi.ctfclient.operacoes.model.PerifericoEventHandler;
import com.csi.ctfclient.operacoes.model.controller.PinpadUtil;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.AbortPinPadListener;
import com.csi.ctfclient.tools.devices.DadosLeitorCartao;
import com.csi.ctfclient.tools.devices.ExcecaoBibliotecaCompartilhada;
import com.csi.ctfclient.tools.devices.ExcecaoComunicacaoSegura;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.ILeitorCartaoHandler;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emv.LeitorCartaoEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoEMV;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.math.BigDecimal;
import java.util.ArrayList;

public class MicHabilitaLeitorCartao {
    private ILogger logger = CTFClientLogger.getCTFClient();
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String CONFIGURA_PINPAD = "CONFIGURA_PINPAD";
    public static final String MSG_SEM_PINPAD = "999 - ERRO CONECTE PINPAD";
    public static final String MSG_ERRO_COMUNICACAO_SEGURA = "ERRO CHAVE";
    private static final String VERSAO_MINIMA_CONTACTLESS = "1.08";
    private static final int TIPO_APLICACAO_LISTA_ESPECIFICA = 0;
    private static final int TIPO_APLICACAO_CREDITO = 1;
    private static final int TIPO_APLICACAO_DEBITO = 2;
    private static final int TIPO_APLICACAO_QUALQUER = 99;

    public String execute(Process dados) throws ExcecaoApiAc {
        boolean cartaoDigitado;
        boolean deliveryInternet;
        ILeitorCartaoHandler cartaoHandler = null;
        ControladorPerifericos perifericos = dados.getPerifericos();
        ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        boolean bl = deliveryInternet = entradaApiTefC.getIdentificacaoTransacao() == 1 || entradaApiTefC.getIdentificacaoTransacao() == 2;
        if (perifericos.getLeitorCartao() != null) {
            LayoutDisplay displayModel = new LayoutDisplay("AGUARDE...");
            displayModel.setImagem(LayoutDisplay.imagens.aguarde_pinpad);
            perifericos.imprimeDisplay(displayModel);
            if (confCTFClient.isIntegracaoDll()) {
                if (perifericos.getEventoNaoEsperadoListener() != null) {
                    perifericos.getLeitorCartao().getLeitorCartao().removeListener(perifericos.getEventoNaoEsperadoListener());
                    perifericos.setEventoNaoEsperadoListener(null);
                    perifericos.setEventoNaoEsperado(null);
                }
                perifericos.setEventoNaoEsperadoListener(new AbortPinPadListener(perifericos));
                perifericos.getLeitorCartao().getLeitorCartao().addListener(perifericos.getEventoNaoEsperadoListener());
            }
        }
        boolean bl2 = cartaoDigitado = Contexto.getContexto().getEntradaIntegracao() != null && (Contexto.getContexto().getEntradaIntegracao().getOperacao() == 120 || Contexto.getContexto().getEntradaIntegracao().getOperacao() == 121 || Contexto.getContexto().getEntradaIntegracao().getOperacao() == 122 || Contexto.getContexto().getEntradaIntegracao().getOperacao() == 302 || Contexto.getContexto().getEntradaIntegracao().getOperacao() == 326 || Contexto.getContexto().getEntradaIntegracao().getOperacao() == 327 || Contexto.getContexto().getEntradaIntegracao().getOperacao() == 328 || Contexto.getContexto().getEntradaIntegracao().getOperacao() == 411);
        if (deliveryInternet || perifericos.getLeitorCartao() == null || cartaoDigitado) {
            return UNECESSARY;
        }
        cartaoHandler = perifericos.getLeitorCartao();
        if (Contexto.getContexto().getCartao() != null && Contexto.getContexto().getCartao() == Cartao.DIGITADO) {
            return SUCESS;
        }
        LeitorCartaoEMV leitorEMV = (LeitorCartaoEMV)cartaoHandler.getLeitorCartao();
        leitorEMV.setIdRedeAdquirente(leitorEMV.getIdRedeAdquirente());
        if (leitorEMV.getIdRedeAdquirente() > 0 && leitorEMV.getIndiceAID() != null) {
            cartaoHandler.getRedeAdquirente();
            ArrayList<Aid> listAID = new ArrayList<Aid>();
            listAID.add(this.createAID(leitorEMV.getIdRedeAdquirente(), leitorEMV.getIndiceAID()));
            leitorEMV.setIdsRedeIndTab(listAID);
        } else {
            leitorEMV.setIdsRedeIndTab(Contexto.getContexto().getListAID());
        }
        DadosLeitorCartao dadosLeitorCartao = (DadosLeitorCartao)((Object)cartaoHandler.getLeitorCartao());
        dadosLeitorCartao.setTipoAplicacao(this.infTipoAplicacao(dados));
        if (entradaApiTefC.getValorTransacao() != null) {
            dadosLeitorCartao.setValorInicialTransacao(this.infValorTransacao(entradaApiTefC.getValorTransacao()));
        }
        CMOSPinPad cmosPinPad = CMOSPinPad.getInstance();
        if (Contexto.getContexto().getSaidaApiTefC() != null && Contexto.getContexto().getSaidaApiTefC().getTipoBibliotecaPinpad() == 2) {
            dadosLeitorCartao.setTimeStamp(cmosPinPad.getTimeStamp(leitorEMV.getIdRedeAdquirente()));
        } else {
            dadosLeitorCartao.setTimeStamp(cmosPinPad.getTimeStamp(0));
        }
        dadosLeitorCartao.setDataTransacao(dados.getStartProcess());
        try {
            boolean habilitaContactless;
            String versaoEspecificacao;
            GetInfo info = Contexto.getContexto().getDadosGetInfo();
            if (info != null) {
                versaoEspecificacao = info.getVersaoEspecificao();
            } else if (perifericos.getPin() != null) {
                SaidaGetInfoEMV saidaGetInfo = perifericos.getPin().getInfo();
                versaoEspecificacao = saidaGetInfo.getVersaoEspecificacao();
            } else {
                versaoEspecificacao = null;
            }
            ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
            IdentTerminal identTerminal = null;
            EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
            boolean multiTerminal = entradaIntegracao != null && entradaIntegracao.isMultiTerminal();
            boolean multiEC = config.isMultiEC();
            identTerminal = entradaIntegracao != null && (multiTerminal || multiEC) ? Contexto.getContexto().getEntradaIntegracao().getIdentTerminal() : new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
            ControladorInicioDia controladorInicioDia = ControladorInicioDia.getInstance();
            DadosInicioDia dadosInicioDia = controladorInicioDia.getDadosInicioDia(identTerminal);
            boolean enviarBufferContactless = PinpadUtil.comparaVersao(VERSAO_MINIMA_CONTACTLESS, versaoEspecificacao);
            if (Contexto.getContexto().isDesabilitaContactlessProximaLeitura()) {
                this.logger.log("INFO", "Cart\u00e3o contactless desabilitado para esta leitura");
                habilitaContactless = false;
            } else if (enviarBufferContactless && dadosInicioDia.isHabilitaContactless()) {
                if (info != null) {
                    habilitaContactless = info.isSuportaContactless();
                } else if (perifericos.getPin() != null) {
                    SaidaGetInfoEMV saidaGetInfo = perifericos.getPin().getInfo();
                    habilitaContactless = saidaGetInfo.isSuportaContactless();
                } else {
                    habilitaContactless = false;
                }
                if (habilitaContactless) {
                    this.logger.log("INFO", "Pinpad suporta contactless");
                } else {
                    this.logger.log("INFO", "Pinpad n\u00e3o suporta contactless");
                }
            } else {
                habilitaContactless = false;
                this.logger.log("INFO", "Cart\u00e3o contactless desabilitado para este terminal ou vers\u00e3o do Pinpad \u00e9 menor que 1.08");
            }
            leitorEMV.setEnviarBufferContactless(enviarBufferContactless);
            leitorEMV.setHabilitaContactless(habilitaContactless);
            entradaApiTefC.setCapacidadeContactlessPinpad(enviarBufferContactless && habilitaContactless);
            cmosPinPad = CMOSPinPad.getInstance();
            PerifericoEventHandler.setActive(true);
            cartaoHandler.habilitaTrilha(1);
            cartaoHandler.habilitaTrilha(2);
            cartaoHandler.habilitaTrilha(3);
            if (confCTFClient.getTentativasConexaoPinpad() == 0) {
                ExcecaoPerifericos ex;
                int cont = 0;
                do {
                    ++cont;
                    ex = null;
                    try {
                        cartaoHandler.habilita();
                    }
                    catch (ExcecaoPerifericos e) {
                        ex = e;
                        LayoutDisplay displayModel = new LayoutDisplay("Erro no PINPAD (" + cont + ")..");
                        perifericos.imprimeDisplay(displayModel);
                        try {
                            Thread.sleep(1500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                } while (ex != null && cont < 10);
                if (ex != null) {
                    throw ex;
                }
            } else {
                cartaoHandler.habilita();
            }
            cmosPinPad.limpaTentativaConexoes();
        }
        catch (ExcecaoInteiroInvalido e) {
            this.logger.log("ERROR", "Erro ao habilitar o leitor cart\u00e3o", e);
            perifericos.liberarRecursosPinCartao();
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5327, MSG_SEM_PINPAD));
            return ERRO;
        }
        catch (ExcecaoBibliotecaCompartilhada e) {
            this.logger.log("ERROR", "Erro ao habilitar o leitor cart\u00e3o", e);
            perifericos.liberarRecursosPinCartao();
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5358, "PINPAD SEM API COMPARTILHADA"));
            return ERRO;
        }
        catch (ExcecaoComunicacaoSegura e) {
            this.logger.log("ERROR", "Erro ao habilitar a comunica\u00e7\u00e3o segura com o pinpad", e);
            perifericos.liberarRecursosPinCartao();
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5386, MSG_ERRO_COMUNICACAO_SEGURA));
            return ERRO;
        }
        catch (ExcecaoPerifericos e) {
            int qtdErro;
            this.logger.log("ERROR", "Erro ao habilitar o leitor cart\u00e3o", e);
            perifericos.liberarRecursosPinCartao();
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5327, MSG_SEM_PINPAD));
            if (!confCTFClient.isIntegracaoAndroid() && confCTFClient.getTentativasConexaoPinpad() > 0 && (qtdErro = cmosPinPad.novaTentativaConexao()) >= confCTFClient.getTentativasConexaoPinpad()) {
                return CONFIGURA_PINPAD;
            }
            return ERRO;
        }
        return SUCESS;
    }

    private long infValorTransacao(BigDecimal bigDecimal) {
        return bigDecimal.movePointRight(2).longValue();
    }

    private int infTipoAplicacao(Process operacao) {
        int tipoAplicacao = 99;
        String tipoOperacao = Contexto.getContexto().getTipoOperacao();
        if ("OPERACAO CREDITO".equals(tipoOperacao) || "CREDITO GENERICO".equals(tipoOperacao)) {
            tipoAplicacao = 1;
        } else if ("OPERACAO DEBITO".equals(tipoOperacao) || "DEBITO GENERICO".equals(tipoOperacao) || "OPE_DEBITO_CREDIARIO".equals(tipoOperacao)) {
            tipoAplicacao = 2;
        } else if ("OPERACAO IATA".equals(tipoOperacao) || "OPERACAO AUTORIZACAO IATA".equals(tipoOperacao) || "OPERACAO CREDITO IATA".equals(tipoOperacao)) {
            tipoAplicacao = 1;
        } else if ("OPERACAO RESGATE PREMIO LISTA AID".equals(tipoOperacao)) {
            tipoAplicacao = 0;
        } else if ("OPE_SIMULACAO_CREDIARIO_CREDITO".equals(tipoOperacao) || "OPE_CREDITO_CREDIARIO".equals(tipoOperacao)) {
            tipoAplicacao = 1;
        } else if ("OPERACAO PRE AUTORIZACAO".equals(tipoOperacao) || "OPERACAO CONFIRMACAO PRE AUTORIZACAO".equals(tipoOperacao)) {
            tipoAplicacao = 1;
        } else if ("OPERACAO CONSULTA FATURA CARTAO".equals(tipoOperacao) || "OPERACAO_CONSULTA_FATURA_CARTAO_DETALHADA".equals(tipoOperacao) || "OPERACAO PAGAMENTO FATURA CARTAO".equals(tipoOperacao)) {
            tipoAplicacao = 1;
        } else if ("OPERACAO CREDITO PRIVATE LABEL".equals(tipoOperacao)) {
            tipoAplicacao = 1;
        } else if ("OPERACAO CANCELAMENTO".equals(tipoOperacao)) {
            if (Contexto.getContexto().getSaidaConsulta() != null && Contexto.getContexto().getSaidaConsulta().getCodigoTransacao() != null) {
                String codigoTransacaoCancelamento = Contexto.getContexto().getSaidaConsulta().getCodigoTransacao();
                if (codigoTransacaoCancelamento.equals("12")) {
                    tipoAplicacao = 1;
                } else if (codigoTransacaoCancelamento.equals("10")) {
                    tipoAplicacao = 2;
                }
            }
        } else if ("OPERACAO CORRESPONDENTE BANCARIO CONSULTA E PAGAMENTO TITULO".equals(tipoOperacao) || "OPERACAO CORRESPONDENTE BANCARIO PAGAMENTO TITULO".equals(tipoOperacao) || "OPERACAO CORRESPONDENTE BANCARIO CONSULTA E PAGAMENTO CONVENIO".equals(tipoOperacao) || "OPERACAO CORRESPONDENTE BANCARIO PAGAMENTO CONVENIO".equals(tipoOperacao)) {
            if (Contexto.getContexto().getTipoPagamento() == 5) {
                tipoAplicacao = 1;
            } else if (Contexto.getContexto().getTipoPagamento() == 4) {
                tipoAplicacao = 2;
            }
        } else if ("OPE_CONTA_DIGITAL_PAGTO_FATURA".equals(tipoOperacao) || "OPE_CONTA_DIGITAL_PAGTO_TITULO".equals(tipoOperacao) || "OPE_CONTA_DIGITAL_PAGTO_CONCESSIONARIA".equals(tipoOperacao)) {
            tipoAplicacao = 1;
        }
        return tipoAplicacao;
    }

    private Aid createAID(int redeAdquirente, Integer indiceAID) {
        Aid aid = new Aid();
        aid.setRede(StringUtil.completaString(String.valueOf(redeAdquirente), 2, '0', 3));
        aid.setIndice(StringUtil.completaString(String.valueOf(indiceAID), 2, '0', 3));
        return aid;
    }
}

