/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.CartaoSeguro;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CMOSPinPad;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.PerifericoEventHandler;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.EventoLeitorCartaoEMV;
import com.csi.ctfclient.tools.devices.emv.LeitorCartaoEMV;
import com.csi.ctfclient.tools.devices.emvfull.KeyFactory;
import com.csi.ctfclient.tools.devices.emvfull.LeitorCartaoBibliotecaCompartilhada;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class MicLeituraCartao {
    public static final String SUCESS_CARDTYPE = "SUCESS_CARDTYPE";
    public static final String SUCESS_CARDCHIP = "SUCESS_CARDCHIP";
    public static final String SUCESS_CARDMAGNETIC = "SUCESS_CARDMAGNETIC";
    public static final String SUCESS_CARDCONTACTLESS_TARJA = "SUCESS_CARDCONTACTLESS_TARJA";
    public static final String SUCESS_CARDCONTACTLESS_EMV = "SUCESS_CARDCONTACTLESS_EMV";
    public static final String NECESSITA_CARGA_TABELA = "NECESSITA_CARGA_TABELA";
    public static final String ERRO_INVALID_NUMBER_TYPE = "ERRO_INVALID_NUMBER_TYPE";
    public static final String ERRO_INVALID_NUMBER_TYPE_AC = "ERRO_INVALID_NUMBER_TYPE_AC";
    public static final String ERRO_READCARD = "ERRO_READCARD";
    public static final String FILLED_CARDTYPE = "FILLED_CARDTYPE";
    public static final String FILLED_CARDCHIP = "FILLED_CARDCHIP";
    public static final String FILLED_CARDMAGNETIC = "FILLED_CARDMAGNETIC";
    public static final String FILLED_CARDCONTACTLESS_EMV = "FILLED_CARDCONTACTLESS_EMV";
    public static final String FILLED_CARDCONTACTLESS_TARJA = "FILLED_CARDCONTACTLESS_TARJA";
    public static final String ERRO = "ERRO";
    public static final String ERRO_CARDCHIP = "ERRO_CARDCHIP";
    public static final String ERRO_COMM = "ERRO_COMM";
    public static final String ERRO_ABORT = "ERRO_ABORT";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String USERCANCEL_RETRY = "USERCANCEL_RETRY";
    public static final String REDIRECT_CREDITO_CELULAR = "REDIRECT_CREDITO_CELULAR";
    public static final String REDIRECT_IDENTIFICACAO_ASSOCIADO = "REDIRECT_IDENTIFICACAO_ASSOCIADO";
    public static final String ERROR_FALLBACK = "ERROR_FALLBACK";
    private static final String MST_ERRO_VALID_CARD = "CARTAO INVALIDO";
    private static final String MST_ERRO_READ_CARD1 = "ERRO DE LEITURA";
    private static final String MST_ERRO_READ_CARD2 = "TENTE NOVAMENTE";
    private static final String MSG_ERRO_FALLBACK = "CARTAO DE FALLBACK DIFERE DO ORIGINAL";
    private static final String MST_ERRO_COMM1 = "VERIFIQUE PINPAD";
    private static ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dado) throws ExcecaoApiAc, ExcecaoPerifericos {
        boolean cartaoDigitado;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (Contexto.getContexto().getCartao() != null) {
            if (Contexto.getContexto().getCartao() == Cartao.CHIP) {
                return FILLED_CARDCHIP;
            }
            if (Contexto.getContexto().getCartao() == Cartao.DIGITADO) {
                return FILLED_CARDTYPE;
            }
            if (Contexto.getContexto().getCartao() == Cartao.MAGNETICO) {
                return FILLED_CARDMAGNETIC;
            }
            if (Contexto.getContexto().getCartao() == Cartao.CONTACTLESS_EMV) {
                return FILLED_CARDCONTACTLESS_EMV;
            }
            if (Contexto.getContexto().getCartao() == Cartao.CONTACTLESS_TARJA) {
                return FILLED_CARDCONTACTLESS_TARJA;
            }
        }
        ControladorPerifericos perifericos = dado.getPerifericos();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (entradaIntegracao != null && entradaIntegracao.isNumeroCartaoCtrl()) {
            try {
                Contexto.getContexto().getEntradaApiTefC().setPAN(entradaIntegracao.getNumeroCartao());
                entrada.setInfo(entradaIntegracao.getNumeroCartao());
                Contexto.getContexto().setCartao(Cartao.DIGITADO);
                entrada.setModoEntrada(1);
                boolean connectedPin = false;
                if (perifericos.getPin() != null) {
                    connectedPin = true;
                    perifericos.getPin().getInfo();
                }
                if (connectedPin && ProtocoloBibliotecaCompartilhada.isComunicacaoSegura()) {
                    if (KeyFactory.isChaveLocal()) {
                        String pan3DESReverso = this.gera3DESReversoCartaoDigitado(Contexto.getContexto().getEntradaApiTefC().getPAN());
                        Contexto.getContexto().getEntradaApiTefC().setPANCripto(pan3DESReverso);
                    } else {
                        CartaoSeguro cartaoSeguro = Contexto.getContexto().getEntradaApiTefC().getCartaoSeguro();
                        if (cartaoSeguro != null) {
                            Contexto.getContexto().getEntradaApiTefC().setPANCripto(cartaoSeguro.getPan());
                        }
                    }
                    if (connectedPin && perifericos.getLeitorCartao() != null) {
                        perifericos.getLeitorCartao().desabilita();
                    }
                }
                Contexto.getContexto().setErrorCode(-1);
                return SUCESS_CARDTYPE;
            }
            catch (IllegalArgumentException e) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5301, MST_ERRO_READ_CARD1));
                return ERRO_INVALID_NUMBER_TYPE_AC;
            }
        }
        if (entradaIntegracao != null && entradaIntegracao.isMultiTerminal()) {
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5301, inter.getMessage("LEICAR_CARTAO_INVALIDO")));
            return ERRO_INVALID_NUMBER_TYPE_AC;
        }
        EventoDispositivoEntrada evento = null;
        String msgDisplay = "";
        ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
        boolean menuCreditoCelularHabilitado = false;
        if ((Contexto.getContexto().getTipoOperacao() == "OPERACAO CREDITO" || Contexto.getContexto().getTipoOperacao() == "CREDITO GENERICO") && config.isCreditoCelularHabilitado()) {
            menuCreditoCelularHabilitado = true;
        }
        if (perifericos.getPin() != null && Contexto.getContexto().getEntradaApiTefC().getIdentificacaoTransacao() == 1) {
            perifericos.getPin().getInfo();
        }
        LayoutDisplay displayModel = null;
        boolean deliveryInternet = entrada.getIdentificacaoTransacao() == 1 || entrada.getIdentificacaoTransacao() == 2;
        boolean bl = cartaoDigitado = Contexto.getContexto().getEntradaIntegracao() != null && (Contexto.getContexto().getEntradaIntegracao().getOperacao() == 120 || Contexto.getContexto().getEntradaIntegracao().getOperacao() == 121 || Contexto.getContexto().getEntradaIntegracao().getOperacao() == 122 || Contexto.getContexto().getEntradaIntegracao().getOperacao() == 302 || Contexto.getContexto().getEntradaIntegracao().getOperacao() == 326 || Contexto.getContexto().getEntradaIntegracao().getOperacao() == 327 || Contexto.getContexto().getEntradaIntegracao().getOperacao() == 328 || Contexto.getContexto().getEntradaIntegracao().getOperacao() == 411);
        do {
            if (perifericos.getLeitorCartao() != null && !deliveryInternet && !cartaoDigitado) {
                if ((perifericos.getLeitorCartao().getSolicitaCargaTabelas() == LeitorCartaoEMV.CARGA_TABELA_OK || perifericos.getLeitorCartao().getSolicitaCargaTabelas() == LeitorCartaoEMV.ERRO_SOLICITA_CARGA_TABELA) && msgDisplay.trim().equals("")) {
                    if (Contexto.getContexto().getTipoOperacao().equals("OPERACAO DEBITO")) {
                        displayModel = this.getDisplayLeituraCartao(perifericos);
                    } else if (Contexto.getContexto().getStatusLeituraCartao() == 1) {
                        displayModel = this.getDisplayLeituraCartao(perifericos);
                    } else if (this.validaFallBack()) {
                        if (perifericos.getLeitorCartao().getSolicitaCargaTabelas() == LeitorCartaoEMV.CARGA_TABELA_OK && msgDisplay.trim().equals("")) {
                            displayModel = new LayoutDisplay();
                            for (int i = 0; i < saida.getDisplayCTF().length; ++i) {
                                String[] mensagem = saida.getDisplayCTF()[i].split("#");
                                for (int x = 0; x < mensagem.length; ++x) {
                                    displayModel.addLinha(new Linha(mensagem[x]));
                                }
                            }
                        }
                    } else {
                        displayModel = this.getDisplayLeituraCartao(perifericos);
                    }
                } else {
                    PerifericoEventHandler.setActive(true);
                    if (!perifericos.getLeitorCartao().isHabilitado()) {
                        perifericos.getLeitorCartao().habilita();
                    }
                }
            } else {
                msgDisplay = inter.getMessage("LEICAR_TITLE_TYPED");
                displayModel = new LayoutDisplay(inter.getMessage("LEICAR_TITLE_TYPED"));
            }
            if (!msgDisplay.equals("")) {
                displayModel = new LayoutDisplay(msgDisplay);
            }
            boolean numeroPreenchido = false;
            while (!numeroPreenchido) {
                numeroPreenchido = true;
                long[] perifericosHabilitados = !cartaoDigitado ? new long[]{1L, 8L} : new long[]{1L};
                evento = perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_CARTAO_DIGITADO, false, "", perifericosHabilitados);
                if (!(evento instanceof EventoTeclado)) continue;
                boolean abort = false;
                if ("ENTRA".equals(((EventoTeclado)evento).getTeclaFinalizadora())) {
                    EventoTeclado eventoTeclado = (EventoTeclado)evento;
                    String numeroDigitado = eventoTeclado.getStringLida().substring(eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados());
                    if (numeroDigitado.length() == 0) {
                        numeroPreenchido = false;
                    }
                } else if ("ABORT".equals(((EventoTeclado)evento).getTeclaFinalizadora())) {
                    abort = true;
                } else if ("VOLTA".equals(((EventoTeclado)evento).getTeclaFinalizadora())) {
                    if (perifericos.exibeMenuCancelamento() == 1) {
                        abort = true;
                    } else {
                        numeroPreenchido = false;
                    }
                }
                if (perifericos.getLeitorCartao() == null || !abort) continue;
                perifericos.getLeitorCartao().desabilita();
                while (perifericos.getLeitorCartao().isLeitura()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        } while (evento instanceof EventoTeclado && "VOLTA".equals(((EventoTeclado)evento).getTeclaFinalizadora()) && perifericos.getLeitorCartao().isHabilitado() && !menuCreditoCelularHabilitado);
        if (evento instanceof EventoLeitorCartaoEMV) {
            EventoLeitorCartaoEMV eventoLeitorCartaoEMV = (EventoLeitorCartaoEMV)evento;
            switch (eventoLeitorCartaoEMV.getErroCodigo()) {
                case 13: {
                    Contexto.getContexto().setErrorCode(-1);
                    return USERCANCEL;
                }
            }
            if (eventoLeitorCartaoEMV.getCartaoComErro()) {
                logger.debug("cartao com erro: " + eventoLeitorCartaoEMV.getErroCodigo());
                entrada.setRetornoBibliotecaCompartilhada(eventoLeitorCartaoEMV.getErroCodigo());
                if (eventoLeitorCartaoEMV.getErroCodigo() == 100) {
                    Contexto.getContexto().setErrorCode(eventoLeitorCartaoEMV.getErroCodigo());
                    Contexto.getContexto().setStatusLeituraCartao(1);
                    return ERRO_CARDCHIP;
                }
                if (eventoLeitorCartaoEMV.getErroCodigo() == 81) {
                    if (Contexto.getContexto().getErrorCode() == 81) {
                        logger.log("INFO", "Retornado o erro PP_CTLSSCOMMERR duas vezes seguidas, desabilitando o contactless na pr\u00f3xima leitura");
                        Contexto.getContexto().setDesabilitaContactlessProximaLeitura(true);
                    }
                    Contexto.getContexto().setErrorCode(eventoLeitorCartaoEMV.getErroCodigo());
                    Contexto.getContexto().setStatusLeituraCartao(1);
                    return ERRO_CARDCHIP;
                }
                if (eventoLeitorCartaoEMV.getErroCodigo() == 82 || eventoLeitorCartaoEMV.getErroCodigo() == 83 || eventoLeitorCartaoEMV.getErroCodigo() == 84 || eventoLeitorCartaoEMV.getErroCodigo() == 85) {
                    logger.log("INFO", "Desabilitando interface contactless o contactless para a pr\u00f3xima leitura");
                    Contexto.getContexto().setDesabilitaContactlessProximaLeitura(true);
                    Contexto.getContexto().setErrorCode(eventoLeitorCartaoEMV.getErroCodigo());
                    Contexto.getContexto().setStatusLeituraCartao(1);
                } else {
                    if (eventoLeitorCartaoEMV.getErroCodigo() >= 22 && eventoLeitorCartaoEMV.getErroCodigo() <= 29) {
                        Contexto.getContexto().setErrorCode(eventoLeitorCartaoEMV.getErroCodigo());
                        Contexto.getContexto().setStatusLeituraCartao(1);
                        return ERRO_CARDCHIP;
                    }
                    if (eventoLeitorCartaoEMV.getErroCodigo() >= 900) {
                        Contexto.getContexto().setErrorCode(68);
                        Contexto.getContexto().setStatusLeituraCartao(1);
                        Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5301, MST_ERRO_READ_CARD1));
                        return ERRO_ABORT;
                    }
                    if (eventoLeitorCartaoEMV.getErroCodigo() >= 50) {
                        Contexto.getContexto().setErrorCode(eventoLeitorCartaoEMV.getErroCodigo());
                        Contexto.getContexto().setStatusLeituraCartao(1);
                        return ERRO_CARDCHIP;
                    }
                }
                switch (eventoLeitorCartaoEMV.getErroCodigo()) {
                    case 20: {
                        Contexto.getContexto().setErrorCode(eventoLeitorCartaoEMV.getErroCodigo());
                        if (config.isIntegracaoAndroid()) {
                            CMOSPinPad.getInstance().refazerCargaTabelas(0);
                        }
                        return NECESSITA_CARGA_TABELA;
                    }
                    case 41: {
                        this.exibeMensagemDuasLinhas(perifericos, MST_ERRO_READ_CARD1, MST_ERRO_READ_CARD2);
                        Contexto.getContexto().setErrorCode(-1);
                        if (Contexto.getContexto().getStatusLeituraCartao() == 1) {
                            Contexto.getContexto().setStatusLeituraCartao(3);
                        }
                        if (entradaIntegracao != null && entradaIntegracao.getOperacao() == 301) {
                            logger.log("INFO", "Leitura de cart\u00e3o de uma Identifica\u00e7\u00e3o de associado associado com erro");
                            return REDIRECT_IDENTIFICACAO_ASSOCIADO;
                        }
                        return ERRO_READCARD;
                    }
                    case 31: {
                        this.exibeMensagemDuasLinhas(perifericos, MST_ERRO_COMM1, "");
                        Contexto.getContexto().setErrorCode(-1);
                        return ERRO_COMM;
                    }
                }
                logger.debug("saida default");
                return ERRO;
            }
            if (this.validaCartao(perifericos, eventoLeitorCartaoEMV)) {
                Contexto.getContexto().setStatusLeituraCartao(0);
                logger.debug("saida verifica cart\u00e3o lido");
                return this.verificaCartaoLido(eventoLeitorCartaoEMV);
            }
        } else if (evento instanceof EventoTeclado) {
            EventoTeclado eventoTeclado = (EventoTeclado)evento;
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                if (menuCreditoCelularHabilitado) {
                    logger.log("INFO", "Cr\u00e9dito com celular habilitado, redirecionando para fluxo de cr\u00e9dito com celular");
                    Contexto.getContexto().setSubfluxoCreditoCelular(true);
                    return REDIRECT_CREDITO_CELULAR;
                }
                Contexto.getContexto().setErrorCode(-1);
                return USERCANCEL;
            }
            if ("ABORT".equals(eventoTeclado.getTeclaFinalizadora())) {
                Contexto.getContexto().setErrorCode(-1);
                return USERCANCEL;
            }
            String numeroDigitado = eventoTeclado.getStringLida().substring(eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados());
            try {
                if (Contexto.getContexto().getStatusLeituraCartao() == 3) {
                    entrada.setFallbackDigitado(true);
                }
                if (this.validaCartaoAnterior(Contexto.getContexto().getEntradaApiTefC().getPAN(), numeroDigitado)) {
                    Contexto.getContexto().setCartao(Cartao.DIGITADO);
                    entrada.setModoEntrada(1);
                    entrada.setInfo(numeroDigitado);
                    entrada.setPAN(numeroDigitado);
                    if (perifericos.getPin() != null) {
                        if (perifericos.getLeitorCartao() != null && !deliveryInternet && !cartaoDigitado) {
                            perifericos.getLeitorCartao().desabilita();
                        }
                        perifericos.getPin().setMsgDisplay(inter.getMessage("ENVIO_TITLE"));
                        if (ProtocoloBibliotecaCompartilhada.isComunicacaoSegura()) {
                            if (KeyFactory.isChaveLocal()) {
                                String pan3DESReverso = this.gera3DESReversoCartaoDigitado(numeroDigitado);
                                entrada.setPANCripto(pan3DESReverso);
                            } else {
                                CartaoSeguro cartaoSeguro = new CartaoSeguro();
                                entrada.setCartaoSeguro(cartaoSeguro);
                            }
                        }
                    }
                    Contexto.getContexto().setErrorCode(-1);
                    return SUCESS_CARDTYPE;
                }
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5399, MSG_ERRO_FALLBACK));
                return ERROR_FALLBACK;
            }
            catch (IllegalArgumentException e) {
                this.exibeMensagem(perifericos, MST_ERRO_VALID_CARD);
                return ERRO_INVALID_NUMBER_TYPE;
            }
        }
        logger.debug("saida cart\u00e3o n\u00e3o emv , teclado");
        return ERRO;
    }

    private boolean validaCartao(ControladorPerifericos perifericos, EventoLeitorCartaoEMV eventoLeitor) throws ExcecaoApiAc {
        if (eventoLeitor.getTrilha1() == null && eventoLeitor.getTrilha2() == null || eventoLeitor.getTrilha1().trim().equals("") && eventoLeitor.getTrilha2().trim().equals("")) {
            this.exibeMensagem(perifericos, MST_ERRO_VALID_CARD);
            return false;
        }
        return true;
    }

    private String verificaCartaoLido(EventoLeitorCartaoEMV eventoLeitor) {
        String retorno = ERRO;
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        String regexNomePortador = "[^(a-zA-Z0-9\\-\\/\\!\\\"\\#\\$\\%\\&\\'\\(\\)\\*\\+\\,\\.\\:\\;\\<\\=\\>\\?\\@\\ )]";
        String numero = MicLeituraCartao.getNumero(eventoLeitor);
        switch (eventoLeitor.getTipoCartao()) {
            case 0: {
                if (Contexto.getContexto().getErrorCode() > 0) {
                    Contexto.getContexto().getEntradaApiTefC().setRetornoBibliotecaCompartilhada(Contexto.getContexto().getErrorCode());
                }
                Contexto.getContexto().setErrorCode(-1);
                if (this.validaCartaoAnterior(Contexto.getContexto().getEntradaApiTefC().getPAN(), numero)) {
                    Contexto.getContexto().setCartao(Cartao.MAGNETICO);
                    entrada.setModoEntrada(2);
                    if (eventoLeitor.getNomePortadorCartao() != null && !eventoLeitor.getNomePortadorCartao().equals("")) {
                        entrada.setNomeCliente(MicLeituraCartao.getNomePortador(eventoLeitor).replaceAll(regexNomePortador, ""));
                    }
                    entrada.setStatusChip(eventoLeitor.getStatusUltLeitura());
                    entrada.setTipoCartao(eventoLeitor.getTipoCartao());
                    entrada.setIssuerCountryCode(eventoLeitor.getIssuerCountryCode());
                    entrada.setWFlags(eventoLeitor.getFlags());
                    entrada.setDadosRedeAdquirente(eventoLeitor.getDadosRestantes());
                    if (KeyFactory.isChaveLocal()) {
                        entrada.setPAN(numero);
                        entrada.setPANCripto(eventoLeitor.getPANCripto());
                        if (eventoLeitor.getTrilha1() != null) {
                            entrada.setTrilha1(eventoLeitor.getTrilha1());
                        }
                        if (eventoLeitor.getTrilha2() != null) {
                            entrada.setInfo(eventoLeitor.getTrilha2());
                        }
                    } else {
                        CartaoSeguro cartaoSeguro = new CartaoSeguro();
                        cartaoSeguro.setPan(eventoLeitor.getPAN());
                        cartaoSeguro.setTrilha1(eventoLeitor.getTrilha1());
                        cartaoSeguro.setTrilha2(eventoLeitor.getTrilha2());
                        entrada.setCartaoSeguro(cartaoSeguro);
                    }
                    retorno = SUCESS_CARDMAGNETIC;
                    break;
                }
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5399, MSG_ERRO_FALLBACK));
                return ERROR_FALLBACK;
            }
            case 3: 
            case 4: {
                if (this.validaCartaoAnterior(Contexto.getContexto().getEntradaApiTefC().getPAN(), numero)) {
                    if (eventoLeitor.getNomePortadorCartao() != null && !eventoLeitor.getNomePortadorCartao().equals("")) {
                        entrada.setNomeCliente(eventoLeitor.getNomePortadorCartao().replaceAll(regexNomePortador, ""));
                    }
                    Contexto.getContexto().setCartao(Cartao.CHIP);
                    entrada.setModoEntrada(5);
                    entrada.setStatusChip(eventoLeitor.getStatusUltLeitura());
                    entrada.setTipoCartao(eventoLeitor.getTipoCartao());
                    entrada.setIssuerCountryCode(eventoLeitor.getIssuerCountryCode());
                    entrada.setWFlags(eventoLeitor.getFlags());
                    if (KeyFactory.isChaveLocal()) {
                        if (eventoLeitor.getTrilha1() != null) {
                            entrada.setTrilha1(eventoLeitor.getTrilha1());
                        }
                        if (eventoLeitor.getTrilha2() != null) {
                            entrada.setInfo(eventoLeitor.getTrilha2());
                        }
                        entrada.setPAN(numero);
                        entrada.setPANCripto(eventoLeitor.getPANCripto());
                        entrada.setNumeroAplicacao(numero);
                    } else {
                        CartaoSeguro cartaoSeguro = new CartaoSeguro();
                        cartaoSeguro.setPan(eventoLeitor.getPAN());
                        cartaoSeguro.setTrilha1(eventoLeitor.getTrilha1());
                        cartaoSeguro.setTrilha2(eventoLeitor.getTrilha2());
                        cartaoSeguro.setNumeroAplicacao(numero);
                        entrada.setCartaoSeguro(cartaoSeguro);
                    }
                    entrada.setIndiceAid(eventoLeitor.getIndiceRegistro());
                    entrada.setCodigoRedeAdquirenteChip(eventoLeitor.getTipoRedeAdquirente());
                    entrada.setCardSequenceNumber(eventoLeitor.getPANSequenceNumber());
                    entrada.setTipoAplicacaoChip(eventoLeitor.getTipoAplicacaoSelecionada());
                    entrada.setApplicationExpirationDate(eventoLeitor.getAppExpirationDate());
                    entrada.setApplicationLabel(eventoLeitor.getAppLabel());
                    entrada.setDadosRedeAdquirente(eventoLeitor.getDadosRestantes());
                    if (Contexto.getContexto().getErrorCode() > 0) {
                        Contexto.getContexto().getEntradaApiTefC().setRetornoBibliotecaCompartilhada(Contexto.getContexto().getErrorCode());
                    }
                    Contexto.getContexto().setErrorCode(0);
                    retorno = SUCESS_CARDCHIP;
                    break;
                }
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5399, MSG_ERRO_FALLBACK));
                return ERROR_FALLBACK;
            }
            case 5: 
            case 6: {
                if (!this.validaCartaoAnterior(Contexto.getContexto().getEntradaApiTefC().getPAN(), numero)) break;
                if (eventoLeitor.getNomePortadorCartao() != null && !eventoLeitor.getNomePortadorCartao().equals("")) {
                    entrada.setNomeCliente(eventoLeitor.getNomePortadorCartao().replaceAll(regexNomePortador, ""));
                }
                if (eventoLeitor.getTipoCartao() == 5) {
                    Contexto.getContexto().setCartao(Cartao.CONTACTLESS_TARJA);
                    entrada.setModoEntrada(6);
                } else if (eventoLeitor.getTipoCartao() == 6) {
                    Contexto.getContexto().setCartao(Cartao.CONTACTLESS_EMV);
                    entrada.setModoEntrada(7);
                    entrada.setIndiceAid(eventoLeitor.getIndiceRegistro());
                    entrada.setCodigoRedeAdquirenteChip(eventoLeitor.getTipoRedeAdquirente());
                    entrada.setCardSequenceNumber(eventoLeitor.getPANSequenceNumber());
                    entrada.setTipoAplicacaoChip(eventoLeitor.getTipoAplicacaoSelecionada());
                    entrada.setApplicationExpirationDate(eventoLeitor.getAppExpirationDate());
                    entrada.setApplicationLabel(eventoLeitor.getAppLabel());
                    entrada.setDadosRedeAdquirente(eventoLeitor.getDadosRestantes());
                }
                entrada.setStatusChip(eventoLeitor.getStatusUltLeitura());
                entrada.setTipoCartao(eventoLeitor.getTipoCartao());
                entrada.setIssuerCountryCode(eventoLeitor.getIssuerCountryCode());
                entrada.setWFlags(eventoLeitor.getFlags());
                if (KeyFactory.isChaveLocal()) {
                    if (eventoLeitor.getTrilha1() != null) {
                        entrada.setTrilha1(eventoLeitor.getTrilha1());
                    }
                    if (eventoLeitor.getTrilha2() != null) {
                        entrada.setInfo(eventoLeitor.getTrilha2());
                    }
                    entrada.setPAN(numero);
                    entrada.setPANCripto(eventoLeitor.getPANCripto());
                    entrada.setNumeroAplicacao(numero);
                } else {
                    CartaoSeguro cartaoSeguro = new CartaoSeguro();
                    cartaoSeguro.setPan(eventoLeitor.getPAN());
                    cartaoSeguro.setTrilha1(eventoLeitor.getTrilha1());
                    cartaoSeguro.setTrilha2(eventoLeitor.getTrilha2());
                    cartaoSeguro.setNumeroAplicacao(numero);
                    entrada.setCartaoSeguro(cartaoSeguro);
                }
                if (Contexto.getContexto().getErrorCode() > 0) {
                    Contexto.getContexto().getEntradaApiTefC().setRetornoBibliotecaCompartilhada(Contexto.getContexto().getErrorCode());
                }
                Contexto.getContexto().setErrorCode(0);
                if (eventoLeitor.getTipoCartao() == 5) {
                    retorno = SUCESS_CARDCONTACTLESS_TARJA;
                    break;
                }
                if (eventoLeitor.getTipoCartao() == 6) {
                    retorno = SUCESS_CARDCONTACTLESS_EMV;
                    break;
                }
                throw new IllegalArgumentException("Tipo inesperado, tratamento contactless");
            }
        }
        return retorno;
    }

    private void exibeMensagem(ControladorPerifericos perifericos, String msg) throws ExcecaoApiAc {
        LayoutDisplay displayModel = new LayoutDisplay(msg);
        displayModel.setImagem(LayoutDisplay.imagens.erro_pinpad);
        perifericos.confirmaDado(displayModel);
    }

    private void exibeMensagemDuasLinhas(ControladorPerifericos perifericos, String msg1, String msg2) throws ExcecaoApiAc {
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.setImagem(LayoutDisplay.imagens.erro_pinpad);
        displayModel.setDelay(1500L);
        displayModel.addLinha(new Linha(msg1));
        displayModel.addLinha(new Linha(msg2));
        perifericos.imprimeDisplay(displayModel);
    }

    public boolean validaFallBack() throws ExcecaoApiAc {
        String operacao;
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        return saidaApiTefC != null && saidaApiTefC.getCodigoRespostaAutorizadora() != null && ((operacao = saidaApiTefC.getCodigoRespostaAutorizadora()).equals("F3") || operacao.equals("0F3"));
    }

    private boolean validaCartaoAnterior(String pan, String panLido) {
        if (pan != null) {
            return pan.equals(panLido);
        }
        return true;
    }

    private String gera3DESReversoCartaoDigitado(String numeroCartao) {
        String panAbertoParaReverter;
        String restantePan = "";
        if (numeroCartao.length() < 16) {
            panAbertoParaReverter = StringUtil.completaString(numeroCartao, 16, 'F', 4);
        } else if (numeroCartao.length() > 16) {
            panAbertoParaReverter = numeroCartao.substring(0, 16);
            restantePan = numeroCartao.substring(16);
        } else {
            panAbertoParaReverter = numeroCartao;
        }
        String pan3DESReverso = "";
        try {
            pan3DESReverso = LeitorCartaoBibliotecaCompartilhada.descriptografaPAN(panAbertoParaReverter, false);
        }
        catch (Exception e) {
            logger.log("ERROR", "Erro ao descriptografar o cartao digitado", e);
        }
        if (numeroCartao.length() > 16) {
            pan3DESReverso = pan3DESReverso + restantePan;
        }
        return pan3DESReverso;
    }

    public static String getNumero(EventoLeitorCartaoEMV eventoLeitor) {
        if (eventoLeitor.getNumeroExternoCartao() != null && eventoLeitor.getNumeroExternoCartao().trim().length() > 0) {
            return eventoLeitor.getNumeroExternoCartao();
        }
        if (eventoLeitor.getPAN() != null && eventoLeitor.getPAN().length() > 0) {
            return eventoLeitor.getPAN();
        }
        int i = 0;
        StringBuffer buffer = new StringBuffer();
        if (!eventoLeitor.getTrilha1().trim().equals("")) {
            if (!Character.isDigit(eventoLeitor.getTrilha1().charAt(0))) {
                ++i;
            }
            while (i < eventoLeitor.getTrilha1().length()) {
                if (Character.isDigit(eventoLeitor.getTrilha1().charAt(i))) {
                    buffer.append(eventoLeitor.getTrilha1().charAt(i));
                } else if (!Character.isSpaceChar(eventoLeitor.getTrilha1().charAt(i))) break;
                ++i;
            }
        }
        i = 0;
        if (buffer.toString().trim().equals("") && !eventoLeitor.getTrilha2().trim().equals("")) {
            if (!Character.isDigit(eventoLeitor.getTrilha2().charAt(0))) {
                ++i;
            }
            while (i < eventoLeitor.getTrilha2().length()) {
                if (Character.isDigit(eventoLeitor.getTrilha2().charAt(i))) {
                    buffer.append(eventoLeitor.getTrilha2().charAt(i));
                } else if (!Character.isSpaceChar(eventoLeitor.getTrilha2().charAt(i))) break;
                ++i;
            }
        }
        return buffer.toString();
    }

    public static String getNomePortador(EventoLeitorCartaoEMV evento) {
        if (evento.getNomePortadorCartao() == null || evento.getNomePortadorCartao().trim().length() == 0) {
            int posInicio = evento.getTrilha1().indexOf(94) + 1;
            if (posInicio == 0) {
                return "";
            }
            int posFim = evento.getTrilha1().indexOf(94, posInicio);
            if (posFim == -1) {
                posFim = evento.getTrilha1().length();
            }
            return evento.getTrilha1().substring(posInicio, posFim);
        }
        return evento.getNomePortadorCartao();
    }

    private LayoutDisplay getDisplayLeituraCartao(ControladorPerifericos perifericos) throws ExcecaoPerifericos {
        LayoutDisplay displayModel;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        LeitorCartaoEMV leitorCartao = null;
        if (perifericos.getLeitorCartao() != null && perifericos.getLeitorCartao().getLeitorCartao() instanceof LeitorCartaoEMV) {
            leitorCartao = (LeitorCartaoEMV)perifericos.getLeitorCartao().getLeitorCartao();
        }
        if (leitorCartao != null && leitorCartao.isHabilitaContactless()) {
            displayModel = new LayoutDisplay(inter.getMessage("LEICAR_TITLE_CONTACTLESS1"));
            if (inter.getMessage("LEICAR_TITLE_CONTACTLESS2").length() > 0) {
                displayModel.addLinha(new Linha(inter.getMessage("LEICAR_TITLE_CONTACTLESS2")));
            }
        } else {
            displayModel = new LayoutDisplay(inter.getMessage("LEICAR_TITLE"));
        }
        displayModel.setImagem(LayoutDisplay.imagens.inserir_cartao);
        return displayModel;
    }
}

