/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.entrada.IleituraGoOnChip;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.ControladorEstatistica;
import com.csi.ctfclient.operacoes.model.DadosEstatistica;
import com.csi.ctfclient.operacoes.model.PerifericoEventHandler;
import com.csi.ctfclient.operacoes.model.PinInfo;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emv.ConstantesEMV;
import com.csi.ctfclient.tools.devices.emv.EventoPinEMV;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class MicLeituraGoOnChip
implements ConstantesEMV {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String ERROR_FALLBACK = "ERROR_FALLBACK";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String USERCANCEL_INTERNAL = "USERCANCEL_INTERNAL";
    private ILogger logger = CTFClientLogger.getPeriferico();

    public String execute(IleituraGoOnChip dados) throws ExcecaoNaoLocal, ExcecaoApiAc {
        ControladorPerifericos perifericos = dados.getPerifericos();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        EventoDispositivoEntrada evento = null;
        LayoutDisplay layoutDisplay = null;
        do {
            if (layoutDisplay != null) {
                perifericos.imprimeDisplay(layoutDisplay);
            }
            evento = perifericos.capturaDado(layoutDisplay, ConstantesApiAc.CAP_LEITURA_PIN, false, new long[]{1L, 4L});
            layoutDisplay = perifericos.getUltimoDisplay();
            if (!(evento instanceof EventoTeclado)) continue;
            boolean abort = false;
            if ("ABORT".equals(((EventoTeclado)evento).getTeclaFinalizadora())) {
                abort = true;
            } else if ("VOLTA".equals(((EventoTeclado)evento).getTeclaFinalizadora()) && perifericos.exibeMenuCancelamento() == 1) {
                abort = true;
            }
            if (!abort || perifericos.getPin() == null) continue;
            perifericos.getPin().desabilita();
            while (perifericos.getPin().isLeitura()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } while (evento instanceof EventoTeclado && "VOLTA".equals(((EventoTeclado)evento).getTeclaFinalizadora()) && perifericos.getPin().getHabilitado());
        if (evento instanceof EventoTeclado) {
            return USERCANCEL;
        }
        EventoPinEMV eventoPinEMV = (EventoPinEMV)evento;
        if (eventoPinEMV.getErroCodigo() == 13) {
            Contexto.getContexto().setErrorCode(0);
            return USERCANCEL;
        }
        if (eventoPinEMV.getErroCodigo() == 50 || eventoPinEMV.getErroCodigo() == 60 || eventoPinEMV.getErroCodigo() == 61 || eventoPinEMV.getErroCodigo() == 70 || eventoPinEMV.getErroCodigo() == 76) {
            if (saidaApiTefC.isPermiteFallbackGoonchip()) {
                this.logger.debug("Fallback habilitado na GoOnChip");
                Contexto.getContexto().setErrorCode(eventoPinEMV.getErroCodigo());
                PerifericoEventHandler.setActive(false);
                return ERROR_FALLBACK;
            }
            this.logger.log("INFO", "Fallback na GoOnChip desabilitado");
        }
        if (eventoPinEMV.getErro()) {
            Contexto.getContexto().setErrorCode(eventoPinEMV.getErroCodigo());
            if (dados.isPossuiChaveContingencia() && eventoPinEMV.getErroCodigo() == 42) {
                this.logger.log("INFO", "Erro ao utilizar a criptografia principal de senha, a conting\u00eancia ser\u00e1 utilizada");
                return ERRO;
            }
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5329, "ERRO NA CAPTURA DO CHIP"));
            return ERRO;
        }
        Contexto.getContexto().setErrorCode(0);
        PinInfo pinInfo = new PinInfo();
        pinInfo.setPinCriptografado(eventoPinEMV.getCodigo());
        pinInfo.setDecisaoTomada(eventoPinEMV.getStatusAprovacaoTransacao());
        pinInfo.setRequerAssinatura(eventoPinEMV.getRequerAssinaturaPapel());
        pinInfo.setVerificadoOffline(eventoPinEMV.getPinVerificadoOffline());
        pinInfo.setNumApresentacoesInvalidasPinOff(eventoPinEMV.getNumApresentacoesInvalidasPinOff());
        pinInfo.setOfflineBloqueado(eventoPinEMV.getPinOfflineBloqueado());
        pinInfo.setNumeroSerieChaveDUKPT(eventoPinEMV.getNumeroSerieChaveDUKPT());
        pinInfo.setDadosCampo55(eventoPinEMV.getCampo55());
        pinInfo.setCapturadoVerificacaoOnline(eventoPinEMV.getPinCapturadoVerificacaoOnline());
        Contexto.getContexto().setPinInfo(pinInfo);
        try {
            boolean persistirDados = false;
            ControladorEstatistica controladorEstatistica = ControladorEstatistica.getInstance();
            DadosEstatistica dadosEstatistica = controladorEstatistica.getDadosEstatistica();
            if (pinInfo.isVerificadoOffline()) {
                dadosEstatistica.addSenhaOfflineChip();
                persistirDados = true;
            } else {
                dadosEstatistica.addSenhaOnlineChip();
                persistirDados = true;
            }
            for (int i = 0; i < pinInfo.getNumApresentacoesInvalidasPinOff(); ++i) {
                dadosEstatistica.addErroSenhaOfflineChip();
                persistirDados = true;
            }
            if (pinInfo.isOfflineBloqueado()) {
                dadosEstatistica.addCartoesBloqErroSenhaChip();
                persistirDados = true;
            }
            if (persistirDados) {
                controladorEstatistica.persistirDados(dadosEstatistica);
            }
        }
        catch (ExcecaoApiAc e) {
            this.logger.error("Erro ao contabilizar estat\u00edstica em MicLeituraPin: ", e);
        }
        return SUCESS;
    }
}

