/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.util.Vector;

public class MicLeituraTipoFinanciamentoCredito {
    public static final String SUCESS_AVISTA = "SUCESS_AVISTA";
    public static final String SUCESS_APRAZOLOJISTA = "SUCESS_APRAZOLOJISTA";
    public static final String SUCESS_APRAZOADMINISTRADO = "SUCESS_APRAZOADMINISTRADO";
    public static final String FILLED = "FILLED";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String ERROR = "ERROR";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        boolean habilitadoAVista = saidaApiTefC.isPedePlanoAVista();
        boolean habilitadoFinanciadoLojista = saidaApiTefC.isPedePlanoLojista();
        boolean habilitadoAdministradora = saidaApiTefC.isPedePlanoAdministradora();
        if (Contexto.getContexto().getPlano() != null) {
            return FILLED;
        }
        if (entradaIntegracao != null && entradaIntegracao.getOperacao() != 223 && entradaIntegracao.getOperacao() != 128 && entradaIntegracao.getOperacao() != 411 && entradaIntegracao.getOperacao() != 404 && entradaIntegracao.getOperacao() != 227 && entradaIntegracao.getOperacao() != 335 && entradaIntegracao.getOperacao() != 343 && entradaIntegracao.getOperacao() != 345 && entradaIntegracao.getOperacao() != 344) {
            int operacao = entradaIntegracao.getOperacao();
            if (operacao == 112 || operacao == 120 || operacao == 326 || operacao == 132 || operacao == 133 || operacao == 303 || operacao == 412) {
                if (habilitadoAVista) {
                    Contexto.getContexto().setPlano(Plano.AVISTA);
                    return SUCESS_AVISTA;
                }
            } else if (operacao == 113 || operacao == 121 || operacao == 327 || operacao == 167 || operacao == 169 || operacao == 304) {
                if (habilitadoFinanciadoLojista) {
                    Contexto.getContexto().setPlano(Plano.LOJISTA);
                    return SUCESS_APRAZOLOJISTA;
                }
            } else if (operacao == 114 || operacao == 122 || operacao == 328 || operacao == 168 || operacao == 170 || operacao == 305) {
                if (habilitadoAdministradora) {
                    Contexto.getContexto().setPlano(Plano.ADMINISTRADORA);
                    return SUCESS_APRAZOADMINISTRADO;
                }
            } else if ((operacao == 343 || operacao == 345 || operacao == 344) && entradaIntegracao.isNumeroParcelasCtrl()) {
                if (entradaIntegracao.getNumeroParcelas() == 1) {
                    Contexto.getContexto().setPlano(Plano.AVISTA);
                } else if (entradaIntegracao.getNumeroParcelas() > 1) {
                    Contexto.getContexto().setPlano(Plano.ADMINISTRADORA);
                }
            }
            if (Contexto.getContexto().getPlano() == null) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5306, inter.getMessage("LEITIPFIN_OPERATION_NOT_ALLOWED")));
                return ERROR;
            }
        } else {
            Vector<String> vtTitleMenu = new Vector<String>();
            if (habilitadoAVista) {
                vtTitleMenu.add(inter.getMessage("LEITIPFIN_MENU_AVISTA"));
            }
            if (habilitadoAdministradora) {
                vtTitleMenu.add(inter.getMessage("LEITIPFIN_MENU_ADMINISTRADORA"));
            }
            if (habilitadoFinanciadoLojista) {
                vtTitleMenu.add(inter.getMessage("LEITIPFIN_MENU_FINANCIADO_LOJISTA"));
            }
            ControladorPerifericos perifericos = dados.getPerifericos();
            if (vtTitleMenu.size() == 0) {
                Contexto.getContexto().setPlano(null);
                return ERROR;
            }
            if (vtTitleMenu.size() == 1) {
                if (habilitadoAVista) {
                    Contexto.getContexto().setPlano(Plano.AVISTA);
                    return SUCESS_AVISTA;
                }
                if (habilitadoAdministradora) {
                    Contexto.getContexto().setPlano(Plano.ADMINISTRADORA);
                    return SUCESS_APRAZOADMINISTRADO;
                }
                if (habilitadoFinanciadoLojista) {
                    Contexto.getContexto().setPlano(Plano.LOJISTA);
                    return SUCESS_APRAZOLOJISTA;
                }
            } else {
                LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("LEITIPFIN_TITLE"), true);
                int iTecla = 1;
                for (int i = 0; i < vtTitleMenu.size(); ++i) {
                    layoutMenu.addItem(new ItemMenu((String)vtTitleMenu.get(i), String.valueOf(iTecla)));
                    ++iTecla;
                }
                int opcao = perifericos.imprimeMenu(layoutMenu);
                if (opcao == -1) {
                    return USERCANCEL;
                }
                ItemMenu itemSelecionado = layoutMenu.getItens().get(opcao - 1);
                if (itemSelecionado.getTexto().equals(inter.getMessage("LEITIPFIN_MENU_AVISTA"))) {
                    Contexto.getContexto().setPlano(Plano.AVISTA);
                    return SUCESS_AVISTA;
                }
                if (itemSelecionado.getTexto().equals(inter.getMessage("LEITIPFIN_MENU_FINANCIADO_LOJISTA"))) {
                    Contexto.getContexto().setPlano(Plano.LOJISTA);
                    return SUCESS_APRAZOLOJISTA;
                }
                if (itemSelecionado.getTexto().equals(inter.getMessage("LEITIPFIN_MENU_ADMINISTRADORA"))) {
                    Contexto.getContexto().setPlano(Plano.ADMINISTRADORA);
                    return SUCESS_APRAZOADMINISTRADO;
                }
            }
        }
        return ERROR;
    }
}

