/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.util.Vector;

public class MicLeituraTipoFinanciamentoDrogao {
    public static final String SUCESS_AVISTA = "SUCESS_AVISTA";
    public static final String SUCESS_APRAZOADMINISTRADO = "SUCESS_APRAZOADMINISTRADO";
    public static final String SUCESS_APRAZOLOJISTA = "SUCESS_APRAZOLOJISTA";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String FILLED = "FILLED";
    public static final String ERROR = "ERROR";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        boolean habilitadoAVista = saidaApiTefC.isPedePlanoAVista();
        boolean habilitadoFinanciadoLojista = saidaApiTefC.isPedePlanoLojista();
        boolean habilitadoAdministradora = saidaApiTefC.isPedePlanoAdministradora();
        if (Contexto.getContexto().getPlano() != null) {
            return FILLED;
        }
        Vector<String> vtTitleMenu = new Vector<String>();
        if (habilitadoAVista) {
            vtTitleMenu.add(inter.getMessage("LEITIPFINIAT_MENU_AVISTA"));
        }
        if (habilitadoAdministradora) {
            vtTitleMenu.add(inter.getMessage("LEITIPFINIAT_MENU_ADMINISTRADORA"));
        }
        if (habilitadoFinanciadoLojista) {
            vtTitleMenu.add(inter.getMessage("LEITIPFINIAT_MENU_FINANCIADO_LOJISTA"));
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        if (vtTitleMenu.size() == 0) {
            Contexto.getContexto().setPlano(null);
            return ERROR;
        }
        if (vtTitleMenu.size() == 1) {
            if (habilitadoAVista) {
                Contexto.getContexto().setPlano(Plano.AVISTA);
                return SUCESS_AVISTA;
            }
            if (habilitadoAdministradora) {
                Contexto.getContexto().setPlano(Plano.ADMINISTRADORA);
                return SUCESS_APRAZOADMINISTRADO;
            }
            if (habilitadoFinanciadoLojista) {
                Contexto.getContexto().setPlano(Plano.LOJISTA);
                return SUCESS_APRAZOLOJISTA;
            }
        } else {
            LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("LEITIPFINIAT_TITLE"), true);
            int iTecla = 1;
            for (int i = 0; i < vtTitleMenu.size(); ++i) {
                layoutMenu.addItem(new ItemMenu((String)vtTitleMenu.get(i), String.valueOf(iTecla)));
                ++iTecla;
            }
            int opcao = perifericos.imprimeMenu(layoutMenu);
            if (opcao == -1) {
                return USER_CANCEL;
            }
            ItemMenu itemSelecionado = layoutMenu.getItens().get(opcao - 1);
            if (itemSelecionado.getTexto().equals(inter.getMessage("LEITIPFINIAT_MENU_AVISTA"))) {
                Contexto.getContexto().setPlano(Plano.AVISTA);
                return SUCESS_AVISTA;
            }
            if (itemSelecionado.getTexto().equals(inter.getMessage("LEITIPFINIAT_MENU_FINANCIADO_LOJISTA"))) {
                Contexto.getContexto().setPlano(Plano.LOJISTA);
                return SUCESS_APRAZOLOJISTA;
            }
            if (itemSelecionado.getTexto().equals(inter.getMessage("LEITIPFINIAT_MENU_ADMINISTRADORA"))) {
                Contexto.getContexto().setPlano(Plano.ADMINISTRADORA);
                return SUCESS_APRAZOADMINISTRADO;
            }
        }
        return ERROR;
    }
}

