/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;

public class MicLeituraValor {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String INVALID_NUMBER = "INVALID_NUMBER";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String ERROR_AC = "ERROR_AC";

    public String execute(Process dados) throws ExcecaoApiAc {
        ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (entradaApiTefC.getValorTransacao() != null) {
            return FILLED;
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null) {
            if (!Contexto.getContexto().getEntradaIntegracao().isValorTransacaoCtrl() && this.valorObrigatorio(confCTFClient, Contexto.getContexto().getEntradaIntegracao().getOperacao())) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5300, "VALOR NAO INFORMADO"));
                return ERROR_AC;
            }
            if (Contexto.getContexto().getEntradaIntegracao().isValorTransacaoCtrl()) {
                Contexto.getContexto().getEntradaApiTefC().setValorTransacao(Contexto.getContexto().getEntradaIntegracao().getValorTransacao());
                return SUCESS;
            }
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        String msg = "";
        msg = confCTFClient.isIntegracaoAndroid() && Contexto.getContexto().getEntradaIntegracao().getOperacao() != 128 ? "VALOR TRANSACAO" : inter.getMessage("LEIVAL_TITLE");
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(msg));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_VALOR_TRANSACAO, true, 3, false);
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            return USERCANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String digitos = eventoTeclado.getStringLida().substring(num);
        if (digitos.equals("")) {
            return INVALID_NUMBER;
        }
        BigDecimal valor = new BigDecimal(digitos);
        if (valor.equals(new BigDecimal(0))) {
            return INVALID_NUMBER;
        }
        valor = valor.movePointLeft(2);
        Contexto.getContexto().getEntradaApiTefC().setValorTransacao(valor);
        return SUCESS;
    }

    private boolean valorObrigatorio(ConfCTFClient confCTFClient, int operacao) {
        if (confCTFClient.isIntegracaoAndroid()) {
            return false;
        }
        switch (operacao) {
            case 128: {
                return false;
            }
            case 411: {
                return false;
            }
            case 156: {
                return false;
            }
            case 174: {
                return false;
            }
            case 236: {
                return false;
            }
            case 900: {
                return false;
            }
            case 264: {
                return false;
            }
            case 340: {
                return false;
            }
            case 183: {
                return false;
            }
            case 286: {
                return false;
            }
            case 260: {
                return false;
            }
            case 289: {
                return false;
            }
            case 290: {
                return false;
            }
            case 331: {
                return false;
            }
            case 404: {
                return false;
            }
        }
        return true;
    }
}

