/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.text.DecimalFormat;

public class MicQuestionaPagamentoValorParcialFuelControl {
    public static final String SUCCESS_VALOR_TOTAL = "SUCCESS_VALOR_TOTAL";
    public static final String SUCCESS_VALOR_PARCIAL = "SUCCESS_VALOR_PARCIAL";
    public static final String DENIED_VALOR_PARCIAL = "DENIED_VALOR_PARCIAL";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String ERROR = "ERROR";
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dados) throws ExcecaoNaoLocal {
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        int codigoRetorno = saida.getRetorno();
        String codigoRespostaCTF = saida.getCodigoRespostaCTF();
        this.logger.log("DEBUG", "C\u00f3digo de retorno: " + codigoRetorno);
        this.logger.log("DEBUG", "C\u00f3digo de resposta do CTF: " + codigoRespostaCTF);
        if (codigoRetorno == 0) {
            if (codigoRespostaCTF == null || !codigoRespostaCTF.equals("01")) {
                return SUCCESS_VALOR_TOTAL;
            }
        } else {
            return ERROR;
        }
        this.logger.log("INFO", "Pagamento parcial do valor da transa\u00e7\u00e3o, questionando o operador");
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        ControladorPerifericos periferico = dados.getPerifericos();
        DecimalFormat format = new DecimalFormat("#,##0.00");
        String valorTransacaoFormatado = format.format(entradaApiTefC.getValorTransacao().doubleValue());
        String valorSaldoFormatado = format.format(saida.getValorTransacao().doubleValue());
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha("SALDO INSUFIC PARA PAGAMENTO TOTAL"));
        displayModel.addLinha(new Linha("VALOR VENDA:    " + valorTransacaoFormatado, 0, 1));
        displayModel.addLinha(new Linha("SALDO APROVADO: " + valorSaldoFormatado));
        displayModel.addLinha(new Linha("CONFIRMA PAGAMENTO PARCIAL?", 0, 2));
        displayModel.addLinha(new Linha("     [1] - SIM"));
        displayModel.addLinha(new Linha("     [2] - NAO"));
        int valor = 0;
        do {
            EventoTeclado eventoTeclado;
            if ((eventoTeclado = (EventoTeclado)periferico.capturaDado(displayModel, true, ConstantesApiAc.CAP_QUESTIONA_PAGAMENTO_VALOR_PARCIAL)).getTeclaFinalizadora().equals("VOLTA")) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5404, "PAGAMENTO PARCIAL DO VALOR DA TRANSACAO NAO AUTORIZADO"));
                return USER_CANCEL;
            }
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            String stringLida = eventoTeclado.getStringLida().substring(num);
            if (stringLida.length() <= 0) continue;
            valor = Integer.parseInt(stringLida.substring(num));
        } while (valor != 1 && valor != 2);
        switch (valor) {
            case 1: {
                return SUCCESS_VALOR_PARCIAL;
            }
            case 2: {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5404, "PAGAMENTO PARCIAL DO VALOR DA TRANSACAO NAO AUTORIZADO"));
                entradaApiTefC.setMotivoDesfazimento(3);
                return DENIED_VALOR_PARCIAL;
            }
        }
        return DENIED_VALOR_PARCIAL;
    }
}

