/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.DadosTelefone;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.TransacoesGenericas;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MicSolicitacaoCancelamento {
    public static final String SUCESS = "SUCESS";
    public static final String ERROR = "ERROR";
    public static final String TRANSACAO_NAO_LOCALIZADA = "TRANSACAO_NAO_LOCALIZADA";
    private static final String MSG_OPERATION_NOT_ALLOWED = "OPERACAO NAO PERMITIDA";
    public static final String OPERACAO = "31";
    public static final String OPERACAO_SEM_LOG = "2W";

    public String execute(Process dados) throws ExcecaoNaoLocal, ExcecaoApiAc {
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        if (Contexto.getContexto().isTransacaoSemLog()) {
            entrada.setOperacao(OPERACAO_SEM_LOG);
            String c = this.getCodigoTransacaoSemLog(dados);
            entrada.setCodigoTransacao(c);
            if (Contexto.getContexto().getPlano() != null) {
                String dataFormatada;
                if (Contexto.getContexto().getPlano() == Plano.PARCELADO) {
                    if (entrada.getDataVencimento() != null) {
                        dataFormatada = new SimpleDateFormat("yyyyMMdd").format(entrada.getDataVencimento());
                        String valorFormatado = entrada.getValorTransacao().movePointRight(2).toString();
                        String bit62Formatado = StringUtil.completaString(valorFormatado + dataFormatada, 20, '0', 3);
                        entrada.setAdicionais(bit62Formatado);
                    }
                } else if (Contexto.getContexto().getPlano() == Plano.PREDATADO && entrada.getDataVencimentoDebito() != null) {
                    dataFormatada = new SimpleDateFormat("yyyyMMdd").format(entrada.getDataVencimentoDebito());
                    String valorFormatado = entrada.getValorTransacao().movePointRight(2).toString();
                    String bit62Formatado = StringUtil.completaString(valorFormatado + dataFormatada, 20, '0', 3);
                    entrada.setAdicionais(bit62Formatado);
                }
            }
        } else {
            String codigoOperacao = this.getCodigoOperacao(dados);
            entrada.setOperacao(codigoOperacao);
        }
        if (entrada.getDdd() != null && entrada.getTelefone() != null) {
            DadosTelefone creditoDigital = new DadosTelefone();
            creditoDigital.setDdd(entrada.getDdd());
            creditoDigital.setTelefone(entrada.getTelefone());
            creditoDigital.setVersaoLayout(conf.getVersaoLayoutCD());
            entrada.setDadosCreditoDigital(creditoDigital);
        }
        entrada.setDataCliente(dados.getStartProcess());
        entrada.setTimeoutCtf(Contexto.getContexto().getSaidaApiTefC().getTimeOutCTF());
        entrada.setTimestamp(new Date());
        ControladorPerifericos periferico = dados.getPerifericos();
        if (!conf.isIntegracaoWeb()) {
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
            displayModel.setImagem(LayoutDisplay.imagens.aguarde_autorizacao);
            periferico.imprimeDisplay(displayModel);
        }
        if (entradaIntegracao != null && entradaIntegracao.getDadosComplementaresTef() != null) {
            entrada.setDadosComplementaresTef(entradaIntegracao.getDadosComplementaresTef());
        }
        SaidaApiTefC saidaApiTefC = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        Contexto.getContexto().setSaidaApiTefC(saidaApiTefC);
        if (saidaApiTefC.getRetorno() != 0) {
            return ERROR;
        }
        VerifyContentUtil.preencheDadosSaida(saidaApiTefC);
        return SUCESS;
    }

    protected String getCodigoOperacao(Process dados) {
        if ("OPERACAO CANCELAMENTO".equals(Contexto.getContexto().getTipoOperacao())) {
            return OPERACAO;
        }
        if ("OPERACAO CANCELAMENTO PRE-AUTORIZACAO".equals(Contexto.getContexto().getTipoOperacao())) {
            return "3G";
        }
        throw new IllegalArgumentException("C\u00f3digo da transa\u00e7\u00e3o n\u00e3o encotrado");
    }

    protected String getCodigoTransacaoSemLog(Process dados) throws IllegalStateException {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        TransacoesGenericas transacoesGenericas = TransacoesGenericas.getInstance(saida.getRedeMenuDinamico());
        if (entradaApiTefC.getFluxoTef() == transacoesGenericas.KEY_FLUXO_DEBITO) {
            if (Contexto.getContexto().getPlano() == Plano.AVISTA) {
                return "10";
            }
            if (Contexto.getContexto().getPlano() == Plano.CDC) {
                Date now = dados.getStartProcess();
                if (entradaApiTefC.getDataVencimento() != null && entradaApiTefC.getDataVencimento().compareTo(now) == 0) {
                    return "5B";
                }
                return "5A";
            }
            if (Contexto.getContexto().getPlano() == Plano.PARCELADO) {
                Date now = dados.getStartProcess();
                if (entradaApiTefC.getDataVencimento() != null && entradaApiTefC.getDataVencimento().compareTo(now) == 0) {
                    return "28";
                }
                return "23";
            }
            if (Contexto.getContexto().getPlano() == Plano.PREDATADO) {
                return "20";
            }
        } else if (entradaApiTefC.getFluxoTef() == transacoesGenericas.KEY_FLUXO_CREDITO) {
            if (Contexto.getContexto().getCartao() == Cartao.DIGITADO) {
                if (Contexto.getContexto().getPlano() == Plano.AVISTA) {
                    return "24";
                }
                if (Contexto.getContexto().getPlano() == Plano.ADMINISTRADORA && Contexto.getContexto().getEntradaApiTefC().getNumeroParcelas() > 1) {
                    return "25";
                }
                if (Contexto.getContexto().getPlano() == Plano.LOJISTA && Contexto.getContexto().getEntradaApiTefC().getNumeroParcelas() > 1) {
                    return "1E";
                }
                if (saida.isRotativoHabilitado()) {
                    return "24";
                }
            } else if (Contexto.getContexto().getCartao() == Cartao.CHIP || Contexto.getContexto().getCartao() == Cartao.MAGNETICO || Contexto.getContexto().getCartao() == Cartao.CONTACTLESS_EMV || Contexto.getContexto().getCartao() == Cartao.CONTACTLESS_TARJA) {
                if (Contexto.getContexto().getPlano() == Plano.AVISTA) {
                    return "12";
                }
                if (Contexto.getContexto().getPlano() == Plano.ADMINISTRADORA && Contexto.getContexto().getEntradaApiTefC().getNumeroParcelas() > 1) {
                    return "22";
                }
                if (Contexto.getContexto().getPlano() == Plano.LOJISTA && Contexto.getContexto().getEntradaApiTefC().getNumeroParcelas() > 1) {
                    return "21";
                }
                if (saida.isRotativoHabilitado()) {
                    return "12";
                }
            }
        } else if (entradaApiTefC.getFluxoTef() == transacoesGenericas.KEY_FLUXO_PRE_AUTORIZACAO) {
            if (Contexto.getContexto().getCartao() == Cartao.DIGITADO) {
                return "7D";
            }
            if (Contexto.getContexto().getCartao() == Cartao.CHIP || Contexto.getContexto().getCartao() == Cartao.MAGNETICO || Contexto.getContexto().getCartao() == Cartao.CONTACTLESS_EMV || Contexto.getContexto().getCartao() == Cartao.CONTACTLESS_TARJA) {
                return "5F";
            }
        } else {
            if (entradaApiTefC.getFluxoTef() == transacoesGenericas.KEY_FLUXO_PGTO_CONTAS) {
                return "2P";
            }
            if (entradaApiTefC.getFluxoTef() == transacoesGenericas.KEY_FLUXO_VOUCHER) {
                return "6A";
            }
        }
        throw new IllegalStateException(MSG_OPERATION_NOT_ALLOWED);
    }
}

