/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class MicSolicitacaoCartaoPrepagoDigital {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        ControladorPerifericos periferico = dados.getPerifericos();
        boolean multiTerminal = entradaIntegracao != null && entradaIntegracao.isMultiTerminal();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        entrada.setOperacao(this.getCodigoTransacao(dados));
        String msg1 = null;
        String msg2 = null;
        String msg3 = null;
        if ("OPERACAO CONSULTA PREPAGO DIGITAL".equals(Contexto.getContexto().getTipoOperacao())) {
            msg1 = "SOLCREDIG_SOLICITACAO_CONSULTA1";
            msg2 = "SOLCREDIG_SOLICITACAO_CONSULTA2";
            msg3 = "SOLCREDIG_SOLICITACAO_CONSULTA3";
        } else if ("OPERACAO PREPAGO DIGITAL".equals(Contexto.getContexto().getTipoOperacao())) {
            msg1 = "ENVTRA_SOLICITACAO1";
            msg2 = "ENVTRA_SOLICITACAO2";
            msg3 = "ENVTRA_SOLICITACAO3";
        }
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage(msg1)));
        displayModel.addLinha(new Linha(inter.getMessage(msg2)));
        displayModel.addLinha(new Linha(inter.getMessage(msg3)));
        periferico.imprimeDisplay(displayModel);
        SaidaApiTefC saida = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        Contexto.getContexto().setSaidaApiTefC(saida);
        if (saida.getRetorno() != 0) {
            this.logger.log("INFO", "Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora());
            return ERROR;
        }
        VerifyContentUtil.preencheDadosSaida(saida);
        return SUCCESS;
    }

    private String getCodigoTransacao(Process dados) {
        if ("OPERACAO CONSULTA PREPAGO DIGITAL".equals(Contexto.getContexto().getTipoOperacao())) {
            return "GK";
        }
        if ("OPERACAO PREPAGO DIGITAL".equals(Contexto.getContexto().getTipoOperacao())) {
            return "GL";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

