/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicSolicitacaoConsultaAvs {
    public static final String SUCESS = "SUCESS";
    public static final String ERROR = "ERROR";
    private static final String OPERACAO = "D6";

    public String execute(Process dados) throws ExcecaoApiAc {
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        if (!conf.isIntegracaoWeb()) {
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage("SOLCONAVS_SOLICITACAO1")));
            displayModel.addLinha(new Linha(inter.getMessage("SOLCONAVS_SOLICITACAO2")));
            periferico.imprimeDisplay(displayModel);
        }
        String dadosAVS = StringUtil.completeStringCHAR(entrada.getCep(), 9) + StringUtil.completeStringCHAR(entrada.getEndereco(), 40) + StringUtil.completeStringCHAR(entrada.getNumeroEndereco(), 6) + StringUtil.completeStringCHAR(entrada.getComplemento(), 5) + StringUtil.completeStringCHAR(entrada.getBloco(), 2) + StringUtil.completeStringCHAR(entrada.getBairro(), 20) + StringUtil.completeStringCHAR(entrada.getCpf(), 11);
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        entrada.setOperacao(OPERACAO);
        entrada.setDadosConsultaAvs(dadosAVS);
        IdentApiTefC ident = Contexto.getContexto().getIdentApiTefC();
        saida = dados.getApitef().solicitacao(ident, entrada);
        Contexto.getContexto().setSaidaApiTefC(saida);
        VerifyContentUtil.preencheDadosSaida(saida);
        if (saida.getRetorno() != 0) {
            return ERROR;
        }
        return SUCESS;
    }
}

