/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorBaixaTecnica;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.operacoes.util.CriptografiaOperacoesUtil;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicSolicitacaoConsultaCDC {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String ERRO_REJEITADO_AUTORIZADORA = "ERRO_REJEITADO_AUTORIZADORA";
    public static final String ERRO_NAO_AUT_CARTAO = "ERRO_NAO_AUT_CARTAO";

    public String execute(Process dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        ControladorBaixaTecnica conBaixaTecnica = ControladorBaixaTecnica.getInstance();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        entrada.setOperacao(this.getCodigoTransacao(dados));
        CriptografiaOperacoesUtil.atualizaEntradaCriptografia(periferico.getPin(), ControladorCriptografia.getTabelaCriptografia());
        if (periferico.getPin() != null && conBaixaTecnica.isBaixaTecnicaSolicitada()) {
            entrada.setFlagBaixaTecnicaVisanet('1');
            entrada.setDadosGeraisPin(conBaixaTecnica.montaDadosGeraisPin());
            entrada.setVersaoAc(ControladorConfCTFClient.getInstance().getConfig().getVersaoAC());
            conBaixaTecnica.persisteBaixaTecnica();
        }
        if (!Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost()) {
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("SOLCONCDC_SOLICITACAO"));
            periferico.imprimeDisplay(displayModel);
        }
        SaidaApiTefC saida = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        if (!Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost()) {
            Contexto.getContexto().setSaidaApiTefC(saida);
            if (saida.getRetorno() != 0) {
                if (saida.getCodigoRespostaAutorizadora().equals("0F5")) {
                    return ERRO_NAO_AUT_CARTAO;
                }
                return ERRO;
            }
            VerifyContentUtil.preencheDadosSaida(saida);
            if (saida.getFlagBaixaTecnica() == '1' || saida.getFlagBaixaTecnica() == '2') {
                conBaixaTecnica.persisteBaixaTecnica();
            }
            return SUCESS;
        }
        return SUCESS;
    }

    protected String getCodigoTransacao(Process dado) throws IllegalStateException {
        if ("OPERACAO CONSULTA CDC COM PARCELA A VISTA".equals(Contexto.getContexto().getTipoOperacao())) {
            if (Contexto.getContexto().getPlano() == Plano.CDC) {
                if (Contexto.getContexto().getEntradaApiTefC().getDataVencimento() != null) {
                    return "5C";
                }
                return "5D";
            }
        } else if ("OPE_SIMULACAO_CREDIARIO_CREDITO".equals(Contexto.getContexto().getTipoOperacao())) {
            return "4F";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

