/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class MicSolicitacaoConsultaDrogao {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dados) throws ExcecaoApiAc {
        boolean connectedPin;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        entrada.setOperacao(this.getCodigoTransacao(dados));
        if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().getDadosComplementaresTef() != null) {
            entrada.setDadosComplementaresTef(Contexto.getContexto().getEntradaIntegracao().getDadosComplementaresTef());
        }
        boolean bl = connectedPin = periferico.getPin() != null;
        if (!Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost()) {
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
            periferico.imprimeDisplay(displayModel);
        }
        if (connectedPin && !Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost()) {
            periferico.getPin().setMsgDisplay(inter.getMessage("ENVIO_TITLE"));
        }
        SaidaApiTefC saida = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        if (!Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost()) {
            Contexto.getContexto().setSaidaApiTefC(saida);
            if (saida.getRetorno() != 0) {
                this.logger.log("INFO", "Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora());
                return ERROR;
            }
            VerifyContentUtil.preencheDadosSaida(saida);
            return SUCCESS;
        }
        return SUCCESS;
    }

    protected String getCodigoTransacao(Process dado) throws IllegalStateException {
        if ("OPERACAO CONSULTA DROGAO COM CARTAO".equals(Contexto.getContexto().getTipoOperacao())) {
            return "3R";
        }
        if ("OPERACAO CONSULTA DROGAO COM CPF".equals(Contexto.getContexto().getTipoOperacao())) {
            return "3S";
        }
        if ("OPERACAO PAGAMENTO DROGAO".equals(Contexto.getContexto().getTipoOperacao())) {
            return "3T";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

