/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.DadosTelefone;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoEMV;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class MicSolicitacaoCreditoDigital {
    public static final String SUCESS = "SUCESS";
    public static final String ERROR = "ERROR";
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dados) throws ExcecaoApiAc {
        boolean otimizacaoAndroid;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        ControladorPerifericos periferico = dados.getPerifericos();
        boolean multiTerminal = entradaIntegracao != null && entradaIntegracao.isMultiTerminal();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        DadosTelefone creditoDigital = new DadosTelefone();
        creditoDigital.setCodigoAutorizadora(entrada.getCodigoAutorizadora());
        if ("COMPRA DE CREDITO DIGITAL".equals(Contexto.getContexto().getTipoOperacao())) {
            if (entrada.isCapturaDigito()) {
                creditoDigital.setDigitoVerificadortelefone(entrada.getDigitoVerificadortelefone());
            }
        } else {
            creditoDigital.setDigitoVerificadortelefone(0);
        }
        creditoDigital.setCodigoUsuarioPdv(entrada.getCodigoUsuarioPdv());
        creditoDigital.setTipoCreditoCompra(entrada.getTipoCreditoCompra());
        creditoDigital.setDdd(entrada.getDdd());
        creditoDigital.setTelefone(entrada.getTelefone());
        creditoDigital.setVersaoLayout(conf.getVersaoLayoutCD());
        entrada.setDadosCreditoDigital(creditoDigital);
        entrada.setOperacao(this.getCodigoTransacao(dados));
        if (entradaIntegracao.isTipoRecargaCelularCtrl()) {
            this.logger.info("Tipo recarga celular: (" + entradaIntegracao.getTipoRecargaCelular() + ")");
            entrada.setTipoRecargaCelular(entradaIntegracao.getTipoRecargaCelular());
        }
        boolean bl = otimizacaoAndroid = conf.isIntegracaoAndroid() && !conf.isCapturaTelefonePinpad();
        if (!multiTerminal && !otimizacaoAndroid) {
            if (periferico.getPin() != null) {
                if (periferico.getPin().isBibliotecaEMV()) {
                    SaidaGetInfoEMV getInfo = periferico.getPin().getInfo();
                    if (getInfo != null) {
                        entrada.setNumeroSeriePin(getInfo.getNumSeriePinpad());
                        entrada.setRetornoGetInfo(getInfo.getRetorno());
                    }
                    entrada.setTipoPin("16");
                } else {
                    entrada.setTipoPin("14");
                }
            } else {
                entrada.setTipoPin("**");
            }
            entrada.setTimeoutCtf(35);
            String msg1 = null;
            String msg2 = null;
            String msg3 = null;
            if ("CONSULTA DE CREDITO DIGITAL".equals(Contexto.getContexto().getTipoOperacao())) {
                msg1 = "SOLCREDIG_SOLICITACAO_CONSULTA1";
                msg2 = "SOLCREDIG_SOLICITACAO_CONSULTA2";
                msg3 = "SOLCREDIG_SOLICITACAO_CONSULTA3";
            } else if ("COMPRA DE CREDITO DIGITAL".equals(Contexto.getContexto().getTipoOperacao())) {
                msg1 = "ENVTRA_SOLICITACAO1";
                msg2 = "ENVTRA_SOLICITACAO2";
                msg3 = "ENVTRA_SOLICITACAO3";
            }
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage(msg1)));
            displayModel.addLinha(new Linha(inter.getMessage(msg2)));
            displayModel.addLinha(new Linha(inter.getMessage(msg3)));
            periferico.imprimeDisplay(displayModel);
        }
        SaidaApiTefC saida = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        Contexto.getContexto().setSaidaApiTefC(saida);
        saida.setOperadoraTelefonia(creditoDigital.getCodigoAutorizadora());
        saida.setDDD(entrada.getDdd());
        saida.setTelefone(entrada.getTelefone());
        if (saida.getRetorno() != 0) {
            this.logger.log("INFO", "Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora());
            return ERROR;
        }
        VerifyContentUtil.preencheDadosSaida(saida);
        return SUCESS;
    }

    private String getCodigoTransacao(Process dados) {
        if ("CONSULTA DE CREDITO DIGITAL".equals(Contexto.getContexto().getTipoOperacao())) {
            return "F4";
        }
        if ("COMPRA DE CREDITO DIGITAL".equals(Contexto.getContexto().getTipoOperacao())) {
            return "F5";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

